/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.s3;

import org.apache.beam.sdk.io.aws2.options.SerializationTestUtil;
import org.apache.beam.sdk.io.aws2.s3.SSECustomerKey;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SSECustomerKeyTest {
    @Test
    public void testBuild() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.buildWithArgs("86glyTlCNZgccSxW8JxMa6ZdjdK3N141glAysPUZ3AA=", null, null, null));
        Assert.assertThrows(IllegalArgumentException.class, () -> this.buildWithArgs(null, "AES256", null, null));
        this.buildWithArgs(null, null, null, null);
        this.buildWithArgs("86glyTlCNZgccSxW8JxMa6ZdjdK3N141glAysPUZ3AA=", "AES256", null, "SDW4BE3CQz7VqDHYKpNC5A==");
        this.buildWithArgs("86glyTlCNZgccSxW8JxMa6ZdjdK3N141glAysPUZ3AA=", "AES256", "SDW4BE3CQz7VqDHYKpNC5A==", "SDW4BE3CQz7VqDHYKpNC5A==");
    }

    public void buildWithArgs(String key, String algorithm, String md5, String encodedMD5) {
        SSECustomerKey sseCustomerKey = SSECustomerKey.builder().key(key).algorithm(algorithm).md5(md5).build();
        Assert.assertEquals((Object)key, (Object)sseCustomerKey.getKey());
        Assert.assertEquals((Object)algorithm, (Object)sseCustomerKey.getAlgorithm());
        Assert.assertEquals((Object)encodedMD5, (Object)sseCustomerKey.getMD5());
    }

    @Test
    public void testJsonSerializeDeserialize() {
        SSECustomerKey emptyKey = SSECustomerKey.builder().build();
        Assertions.assertThat((Object)this.jsonSerializeDeserialize(emptyKey)).isEqualToComparingFieldByField((Object)emptyKey);
        SSECustomerKey key = SSECustomerKey.builder().key("key").algorithm("algo").md5("md5").build();
        Assertions.assertThat((Object)this.jsonSerializeDeserialize(key)).isEqualToComparingFieldByField((Object)key);
    }

    private SSECustomerKey jsonSerializeDeserialize(SSECustomerKey key) {
        return SerializationTestUtil.serializeDeserialize(SSECustomerKey.class, key);
    }
}

