/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.s3;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.beam.sdk.io.aws2.options.S3Options;
import org.apache.beam.sdk.io.aws2.s3.S3FileSystemConfiguration;
import org.apache.beam.sdk.io.aws2.s3.S3ResourceId;
import org.apache.beam.sdk.io.aws2.s3.S3TestUtils;
import org.apache.beam.sdk.io.aws2.s3.S3WritableByteChannel;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;

@RunWith(value=JUnit4.class)
public class S3WritableByteChannelTest {
    @Test
    public void write() throws IOException {
        this.writeFromConfig(S3TestUtils.s3Config("s3"), false);
        this.writeFromConfig(S3TestUtils.s3Config("s3"), true);
        this.writeFromConfig(S3TestUtils.s3ConfigWithSSEAlgorithm("s3"), false);
        this.writeFromConfig(S3TestUtils.s3ConfigWithSSECustomerKey("s3"), false);
        this.writeFromConfig(S3TestUtils.s3ConfigWithSSEKMSKeyId("s3"), false);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.writeFromConfig(S3TestUtils.s3ConfigWithMultipleSSEOptions("s3"), false));
    }

    @Test
    public void writeWithS3Options() throws IOException {
        this.writeFromOptions(S3TestUtils.s3Options(), false);
        this.writeFromOptions(S3TestUtils.s3Options(), true);
        this.writeFromOptions(S3TestUtils.s3OptionsWithSSEAlgorithm(), false);
        this.writeFromOptions(S3TestUtils.s3OptionsWithSSECustomerKey(), false);
        this.writeFromOptions(S3TestUtils.s3OptionsWithSSEKMSKeyId(), false);
        Assert.assertThrows(IllegalArgumentException.class, () -> this.writeFromOptions(S3TestUtils.s3OptionsWithMultipleSSEOptions(), false));
    }

    private void writeFromOptions(S3Options options, boolean writeReadOnlyBuffer) throws IOException {
        S3Client mockS3Client = (S3Client)Mockito.mock(S3Client.class, (MockSettings)Mockito.withSettings().defaultAnswer(Mockito.RETURNS_SMART_NULLS));
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://bucket/dir/file");
        Supplier channel = () -> new S3WritableByteChannel(mockS3Client, path, "text/plain", S3FileSystemConfiguration.fromS3Options((S3Options)options));
        this.write(mockS3Client, channel, path, options.getSSEAlgorithm(), S3TestUtils.toMd5(options.getSSECustomerKey()), options.getSSEKMSKeyId(), options.getS3UploadBufferSizeBytes().intValue(), options.getBucketKeyEnabled(), writeReadOnlyBuffer);
    }

    private void writeFromConfig(S3FileSystemConfiguration config, boolean writeReadOnlyBuffer) throws IOException {
        S3Client mockS3Client = (S3Client)Mockito.mock(S3Client.class, (MockSettings)Mockito.withSettings().defaultAnswer(Mockito.RETURNS_SMART_NULLS));
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://bucket/dir/file");
        Supplier channel = () -> new S3WritableByteChannel(mockS3Client, path, "text/plain", config);
        this.write(mockS3Client, channel, path, config.getSSEAlgorithm(), S3TestUtils.toMd5(config.getSSECustomerKey()), config.getSSEKMSKeyId(), config.getS3UploadBufferSizeBytes(), config.getBucketKeyEnabled(), writeReadOnlyBuffer);
    }

    private void write(S3Client mockS3Client, Supplier channelSupplier, S3ResourceId path, String sseAlgorithmStr, String sseCustomerKeyMd5, String ssekmsKeyId, long s3UploadBufferSizeBytes, boolean bucketKeyEnabled, boolean writeReadOnlyBuffer) throws IOException {
        CreateMultipartUploadResponse.Builder builder = CreateMultipartUploadResponse.builder().uploadId("upload-id");
        ServerSideEncryption sseAlgorithm = ServerSideEncryption.fromValue((String)sseAlgorithmStr);
        if (sseAlgorithm != null) {
            builder.serverSideEncryption(sseAlgorithm);
        }
        if (sseCustomerKeyMd5 != null) {
            builder.sseCustomerKeyMD5(sseCustomerKeyMd5);
        }
        if (ssekmsKeyId != null) {
            sseAlgorithm = ServerSideEncryption.AWS_KMS;
            builder.serverSideEncryption(sseAlgorithm);
        }
        builder.bucketKeyEnabled(Boolean.valueOf(bucketKeyEnabled));
        CreateMultipartUploadResponse createMultipartUploadResponse = (CreateMultipartUploadResponse)builder.build();
        ((S3Client)Mockito.doReturn((Object)createMultipartUploadResponse).when((Object)mockS3Client)).createMultipartUpload((CreateMultipartUploadRequest)ArgumentMatchers.any(CreateMultipartUploadRequest.class));
        CreateMultipartUploadRequest createMultipartUploadRequest = (CreateMultipartUploadRequest)CreateMultipartUploadRequest.builder().bucket(path.getBucket()).key(path.getKey()).build();
        CreateMultipartUploadResponse mockCreateMultipartUploadResponse1 = mockS3Client.createMultipartUpload(createMultipartUploadRequest);
        Assert.assertEquals((Object)sseAlgorithm, (Object)mockCreateMultipartUploadResponse1.serverSideEncryption());
        Assert.assertEquals((Object)sseCustomerKeyMd5, (Object)mockCreateMultipartUploadResponse1.sseCustomerKeyMD5());
        Assert.assertEquals((Object)bucketKeyEnabled, (Object)mockCreateMultipartUploadResponse1.bucketKeyEnabled());
        UploadPartResponse.Builder uploadPartResponseBuilder = UploadPartResponse.builder().eTag("etag");
        if (sseCustomerKeyMd5 != null) {
            uploadPartResponseBuilder.sseCustomerKeyMD5(sseCustomerKeyMd5);
        }
        UploadPartResponse response = (UploadPartResponse)uploadPartResponseBuilder.build();
        ((S3Client)Mockito.doReturn((Object)response).when((Object)mockS3Client)).uploadPart((UploadPartRequest)ArgumentMatchers.any(UploadPartRequest.class), (RequestBody)ArgumentMatchers.any(RequestBody.class));
        UploadPartResponse mockUploadPartResult = mockS3Client.uploadPart((UploadPartRequest)UploadPartRequest.builder().build(), RequestBody.empty());
        Assert.assertEquals((Object)sseCustomerKeyMd5, (Object)mockUploadPartResult.sseCustomerKeyMD5());
        S3WritableByteChannel channel = channelSupplier.get();
        int contentSize = 0x2080000;
        ByteBuffer uploadContent = ByteBuffer.allocate((int)((double)contentSize * 2.5));
        for (int i = 0; i < contentSize; ++i) {
            uploadContent.put((byte)-1);
        }
        uploadContent.flip();
        int uploadedSize = channel.write(writeReadOnlyBuffer ? uploadContent.asReadOnlyBuffer() : uploadContent);
        Assert.assertEquals((long)contentSize, (long)uploadedSize);
        CompleteMultipartUploadResponse completeMultipartUploadResponse = (CompleteMultipartUploadResponse)CompleteMultipartUploadResponse.builder().build();
        ((S3Client)Mockito.doReturn((Object)completeMultipartUploadResponse).when((Object)mockS3Client)).completeMultipartUpload((CompleteMultipartUploadRequest)ArgumentMatchers.any(CompleteMultipartUploadRequest.class));
        channel.close();
        int partQuantity = (int)Math.ceil((double)contentSize / (double)s3UploadBufferSizeBytes) + 1;
        ((S3Client)Mockito.verify((Object)mockS3Client, (VerificationMode)Mockito.times((int)2))).createMultipartUpload((CreateMultipartUploadRequest)ArgumentMatchers.isNotNull());
        ((S3Client)Mockito.verify((Object)mockS3Client, (VerificationMode)Mockito.times((int)partQuantity))).uploadPart((UploadPartRequest)ArgumentMatchers.isNotNull(), (RequestBody)ArgumentMatchers.any(RequestBody.class));
        ((S3Client)Mockito.verify((Object)mockS3Client, (VerificationMode)Mockito.times((int)1))).completeMultipartUpload((CompleteMultipartUploadRequest)ArgumentMatchers.notNull());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockS3Client});
    }

    @Test
    public void testAtMostOne() {
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false}));
        Assert.assertFalse((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true, true}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true, false}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false, true}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false, false}));
        Assert.assertFalse((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true, true, true}));
        Assert.assertFalse((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true, true, false}));
        Assert.assertFalse((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true, false, true}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{true, false, false}));
        Assert.assertFalse((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false, true, true}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false, true, false}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false, false, true}));
        Assert.assertTrue((boolean)S3WritableByteChannel.atMostOne((boolean[])new boolean[]{false, false, false}));
    }

    @FunctionalInterface
    public static interface Supplier {
        public S3WritableByteChannel get() throws IOException;
    }
}

