/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.s3;

import java.util.Base64;
import org.apache.beam.sdk.io.aws2.options.S3Options;
import org.apache.beam.sdk.io.aws2.s3.DefaultS3ClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.s3.S3FileSystem;
import org.apache.beam.sdk.io.aws2.s3.S3FileSystemConfiguration;
import org.apache.beam.sdk.io.aws2.s3.SSECustomerKey;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.commons.codec.digest.DigestUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.mockito.Mockito;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;

class S3TestUtils {
    S3TestUtils() {
    }

    private static S3FileSystemConfiguration.Builder configBuilder(String scheme) {
        S3Options options = (S3Options)PipelineOptionsFactory.as(S3Options.class);
        options.setAwsRegion(Region.US_WEST_1);
        options.setS3UploadBufferSizeBytes(Integer.valueOf(0x500000));
        return S3FileSystemConfiguration.builderFrom((S3Options)options).setScheme(scheme);
    }

    static S3FileSystemConfiguration s3Config(String scheme) {
        return S3TestUtils.configBuilder(scheme).build();
    }

    static S3Options s3Options() {
        S3Options options = (S3Options)PipelineOptionsFactory.as(S3Options.class);
        options.setAwsRegion(Region.US_WEST_1);
        options.setS3UploadBufferSizeBytes(Integer.valueOf(0x500000));
        return options;
    }

    static S3Options s3OptionsWithPathStyleAccessEnabled() {
        S3Options options = (S3Options)PipelineOptionsFactory.as(S3Options.class);
        options.setAwsRegion(Region.US_WEST_1);
        options.setS3UploadBufferSizeBytes(Integer.valueOf(0x500000));
        options.setS3ClientFactoryClass(PathStyleAccessS3ClientBuilderFactory.class);
        return options;
    }

    static S3FileSystemConfiguration s3ConfigWithPathStyleAccessEnabled(String scheme) {
        return S3FileSystemConfiguration.builderFrom((S3Options)S3TestUtils.s3OptionsWithPathStyleAccessEnabled()).setScheme(scheme).build();
    }

    static S3FileSystemConfiguration s3ConfigWithSSEAlgorithm(String scheme) {
        return S3TestUtils.configBuilder(scheme).setSSEAlgorithm(ServerSideEncryption.AES256.name()).build();
    }

    static S3Options s3OptionsWithSSEAlgorithm() {
        S3Options options = S3TestUtils.s3Options();
        options.setSSEAlgorithm(ServerSideEncryption.AES256.name());
        return options;
    }

    static S3FileSystemConfiguration s3ConfigWithSSECustomerKey(String scheme) {
        return S3TestUtils.configBuilder(scheme).setSSECustomerKey(SSECustomerKey.builder().key("86glyTlCNZgccSxW8JxMa6ZdjdK3N141glAysPUZ3AA=").algorithm("AES256").build()).build();
    }

    static S3Options s3OptionsWithSSECustomerKey() {
        S3Options options = S3TestUtils.s3Options();
        options.setSSECustomerKey(SSECustomerKey.builder().key("86glyTlCNZgccSxW8JxMa6ZdjdK3N141glAysPUZ3AA=").algorithm("AES256").build());
        return options;
    }

    static S3FileSystemConfiguration s3ConfigWithSSEKMSKeyId(String scheme) {
        String ssekmsKeyId = "arn:aws:kms:eu-west-1:123456789012:key/dc123456-7890-ABCD-EF01-234567890ABC";
        return S3TestUtils.configBuilder(scheme).setSSEAlgorithm("aws:kms").setSSEKMSKeyId(ssekmsKeyId).setBucketKeyEnabled(true).build();
    }

    static S3Options s3OptionsWithSSEKMSKeyId() {
        S3Options options = S3TestUtils.s3Options();
        String ssekmsKeyId = "arn:aws:kms:eu-west-1:123456789012:key/dc123456-7890-ABCD-EF01-234567890ABC";
        options.setSSEKMSKeyId(ssekmsKeyId);
        options.setSSEAlgorithm("aws:kms");
        options.setBucketKeyEnabled(true);
        return options;
    }

    static S3FileSystemConfiguration s3ConfigWithMultipleSSEOptions(String scheme) {
        return S3TestUtils.s3ConfigWithSSEKMSKeyId(scheme).toBuilder().setSSECustomerKey(SSECustomerKey.builder().key("86glyTlCNZgccSxW8JxMa6ZdjdK3N141glAysPUZ3AA=").algorithm("AES256").build()).build();
    }

    static S3Options s3OptionsWithMultipleSSEOptions() {
        S3Options options = S3TestUtils.s3OptionsWithSSEKMSKeyId();
        options.setSSECustomerKey(SSECustomerKey.builder().key("86glyTlCNZgccSxW8JxMa6ZdjdK3N141glAysPUZ3AA=").algorithm("AES256").build());
        return options;
    }

    static S3FileSystem buildMockedS3FileSystem(S3FileSystemConfiguration config) {
        return S3TestUtils.buildMockedS3FileSystem(config, (S3Client)Mockito.mock(S3Client.class));
    }

    static S3FileSystem buildMockedS3FileSystem(S3Options options) {
        return S3TestUtils.buildMockedS3FileSystem(options, (S3Client)Mockito.mock(S3Client.class));
    }

    static S3FileSystem buildMockedS3FileSystem(S3FileSystemConfiguration config, S3Client client) {
        S3FileSystem s3FileSystem = new S3FileSystem(config);
        s3FileSystem.setS3Client(client);
        return s3FileSystem;
    }

    static S3FileSystem buildMockedS3FileSystem(S3Options options, S3Client client) {
        S3FileSystem s3FileSystem = new S3FileSystem(options);
        s3FileSystem.setS3Client(client);
        return s3FileSystem;
    }

    static @Nullable String toMd5(SSECustomerKey key) {
        if (key != null && key.getKey() != null) {
            return Base64.getEncoder().encodeToString(DigestUtils.md5((byte[])Base64.getDecoder().decode(key.getKey())));
        }
        return null;
    }

    static @Nullable String getSSECustomerKeyMd5(S3FileSystemConfiguration config) {
        return S3TestUtils.toMd5(config.getSSECustomerKey());
    }

    static @Nullable String getSSECustomerKeyMd5(S3Options options) {
        return S3TestUtils.toMd5(options.getSSECustomerKey());
    }

    private static class PathStyleAccessS3ClientBuilderFactory
    extends DefaultS3ClientBuilderFactory {
        private PathStyleAccessS3ClientBuilderFactory() {
        }

        public S3ClientBuilder createBuilder(S3Options s3Options) {
            S3ClientBuilder s3ClientBuilder = super.createBuilder(s3Options);
            return (S3ClientBuilder)s3ClientBuilder.serviceConfiguration((S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(true)).build());
        }
    }
}

