/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.s3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.aws2.options.S3Options;
import org.apache.beam.sdk.io.aws2.s3.S3ResourceId;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.fs.ResourceIdTester;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import software.amazon.awssdk.regions.Region;

@RunWith(value=JUnit4.class)
public class S3ResourceIdTest {
    private static final List<TestCase> PATH_TEST_CASES = Arrays.asList(new TestCase("s3://bucket/", "", ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY, "s3://bucket/"), new TestCase("s3://bucket", "", ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY, "s3://bucket/"), new TestCase("s3://bucket", "path/to/dir", ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY, "s3://bucket/path/to/dir/"), new TestCase("s3://bucket", "path/to/object", ResolveOptions.StandardResolveOptions.RESOLVE_FILE, "s3://bucket/path/to/object"), new TestCase("s3://bucket/path/to/dir/", "..", ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY, "s3://bucket/path/to/"));

    private S3ResourceId deserializeFromB64(String base64) throws Exception {
        ByteArrayInputStream b = new ByteArrayInputStream(Base64.getDecoder().decode(base64));
        try (ObjectInputStream s = new ObjectInputStream(b);){
            S3ResourceId s3ResourceId = (S3ResourceId)s.readObject();
            return s3ResourceId;
        }
    }

    private String serializeToB64(S3ResourceId r) throws Exception {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try (ObjectOutputStream s = new ObjectOutputStream(b);){
            s.writeObject(r);
        }
        return Base64.getEncoder().encodeToString(b.toByteArray());
    }

    @Test
    public void testSerialization() throws Exception {
        String r1Serialized = "rO0ABXNyACtvcmcuYXBhY2hlLmJlYW0uc2RrLmlvLmF3czIuczMuUzNSZXNvdXJjZUlkC+xJufQ6MnwCAAVMAAZidWNrZXR0ABJMamF2YS9sYW5nL1N0cmluZztMAANrZXlxAH4AAUwADGxhc3RNb2RpZmllZHQAEExqYXZhL3V0aWwvRGF0ZTtMAAZzY2hlbWVxAH4AAUwABHNpemV0ABBMamF2YS9sYW5nL0xvbmc7eHB0AAZidWNrZXR0AAYvYS9iL2NwdAACczNw";
        String r2Serialized = "rO0ABXNyACtvcmcuYXBhY2hlLmJlYW0uc2RrLmlvLmF3czIuczMuUzNSZXNvdXJjZUlkC+xJufQ6MnwCAAVMAAZidWNrZXR0ABJMamF2YS9sYW5nL1N0cmluZztMAANrZXlxAH4AAUwADGxhc3RNb2RpZmllZHQAEExqYXZhL3V0aWwvRGF0ZTtMAAZzY2hlbWVxAH4AAUwABHNpemV0ABBMamF2YS9sYW5nL0xvbmc7eHB0AAxvdGhlci1idWNrZXR0AAYveC95L3pwdAACczNw";
        String r3Serialized = "rO0ABXNyACtvcmcuYXBhY2hlLmJlYW0uc2RrLmlvLmF3czIuczMuUzNSZXNvdXJjZUlkC+xJufQ6MnwCAAVMAAZidWNrZXR0ABJMamF2YS9sYW5nL1N0cmluZztMAANrZXlxAH4AAUwADGxhc3RNb2RpZmllZHQAEExqYXZhL3V0aWwvRGF0ZTtMAAZzY2hlbWVxAH4AAUwABHNpemV0ABBMamF2YS9sYW5nL0xvbmc7eHB0AAx0aGlyZC1idWNrZXR0AAkvZm9vL2Jhci9wdAACczNw";
        String r4Serialized = "rO0ABXNyACtvcmcuYXBhY2hlLmJlYW0uc2RrLmlvLmF3czIuczMuUzNSZXNvdXJjZUlkC+xJufQ6MnwCAAVMAAZidWNrZXR0ABJMamF2YS9sYW5nL1N0cmluZztMAANrZXlxAH4AAUwADGxhc3RNb2RpZmllZHQAEExqYXZhL3V0aWwvRGF0ZTtMAAZzY2hlbWVxAH4AAUwABHNpemV0ABBMamF2YS9sYW5nL0xvbmc7eHB0AApiYXotYnVja2V0dAAGL2EvYi9jcHQAAnMzcA==";
        S3ResourceId r1 = S3ResourceId.fromComponents((String)"s3", (String)"bucket", (String)"a/b/c");
        S3ResourceId r2 = S3ResourceId.fromComponents((String)"s3", (String)"other-bucket", (String)"x/y/z").withSize(123L);
        S3ResourceId r3 = S3ResourceId.fromComponents((String)"s3", (String)"third-bucket", (String)"foo/bar/").withLastModified(Date.from(LocalDate.of(2021, 6, 3).atStartOfDay(ZoneOffset.UTC).toInstant()));
        S3ResourceId r4 = S3ResourceId.fromComponents((String)"s3", (String)"baz-bucket", (String)"a/b/c").withSize(42L).withLastModified(Date.from(LocalDate.of(2016, 6, 15).atStartOfDay(ZoneOffset.UTC).toInstant()));
        S3ResourceId r5 = S3ResourceId.fromComponents((String)"other-scheme", (String)"bucket", (String)"a/b/c");
        S3ResourceId r6 = S3ResourceId.fromComponents((String)"other-scheme", (String)"baz-bucket", (String)"foo/bar/").withSize(42L).withLastModified(Date.from(LocalDate.of(2016, 6, 5).atStartOfDay(ZoneOffset.UTC).toInstant()));
        Assert.assertEquals((Object)r1, (Object)this.deserializeFromB64(r1Serialized));
        Assert.assertEquals((Object)r2, (Object)this.deserializeFromB64(r2Serialized));
        Assert.assertEquals((Object)r3, (Object)this.deserializeFromB64(r3Serialized));
        Assert.assertEquals((Object)r4, (Object)this.deserializeFromB64(r4Serialized));
        Assert.assertEquals((Object)r1, (Object)this.deserializeFromB64(this.serializeToB64(r1)));
        Assert.assertEquals((Object)r2, (Object)this.deserializeFromB64(this.serializeToB64(r2)));
        Assert.assertEquals((Object)r3, (Object)this.deserializeFromB64(this.serializeToB64(r3)));
        Assert.assertEquals((Object)r4, (Object)this.deserializeFromB64(this.serializeToB64(r4)));
        Assert.assertEquals((Object)r5, (Object)this.deserializeFromB64(this.serializeToB64(r5)));
        Assert.assertEquals((Object)r6, (Object)this.deserializeFromB64(this.serializeToB64(r6)));
    }

    @Test
    public void testResolve() {
        for (TestCase testCase : PATH_TEST_CASES) {
            S3ResourceId resourceId = S3ResourceId.fromUri((String)testCase.baseUri);
            ResourceId resolved = resourceId.resolve(testCase.relativePath, (ResolveOptions)testCase.resolveOptions);
            Assert.assertEquals((Object)testCase.expectedResult, (Object)resolved.toString());
        }
        Assert.assertEquals((Object)S3ResourceId.fromUri((String)"s3://bucket/tmp/aa"), (Object)S3ResourceId.fromUri((String)"s3://bucket/tmp/").resolve("aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
        Assert.assertEquals((Object)S3ResourceId.fromUri((String)"s3://bucket/tmp/aa/bb/cc/"), (Object)S3ResourceId.fromUri((String)"s3://bucket/tmp/").resolve("aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("bb", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY).resolve("cc", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY));
        Assert.assertEquals((Object)S3ResourceId.fromUri((String)"s3://bucket/tmp/aa"), (Object)S3ResourceId.fromUri((String)"s3://bucket/tmp/bb/").resolve("s3://bucket/tmp/aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
        Assert.assertEquals((Object)S3ResourceId.fromUri((String)"s3://my-bucket/tmp"), (Object)S3ResourceId.fromUri((String)"s3://my-bucket").resolve("tmp", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
        Assert.assertEquals((Object)S3ResourceId.fromUri((String)"s3://bucket/\u8f93\u51fa \u76ee\u5f55/\u8f93\u51fa \u6587\u4ef601.txt"), (Object)S3ResourceId.fromUri((String)"s3://bucket/\u8f93\u51fa \u76ee\u5f55/").resolve("\u8f93\u51fa \u6587\u4ef601.txt", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
    }

    @Test
    public void testResolveInvalidInputs() {
        Assert.assertThrows((String)"Cannot resolve a file with a directory path: [tmp/]", IllegalArgumentException.class, () -> S3ResourceId.fromUri((String)"s3://my_bucket/").resolve("tmp/", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
    }

    @Test
    public void testResolveInvalidNotDirectory() {
        ResourceId tmpDir = S3ResourceId.fromUri((String)"s3://my_bucket/").resolve("tmp dir", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
        Assert.assertThrows((String)"Expected this resource to be a directory, but was [s3://my_bucket/tmp dir]", IllegalStateException.class, () -> tmpDir.resolve("aa", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE));
    }

    @Test
    public void testS3ResolveWithFileBase() {
        S3ResourceId resourceId = S3ResourceId.fromUri((String)"s3://bucket/path/to/file");
        Assert.assertThrows(IllegalStateException.class, () -> S3ResourceIdTest.lambda$testS3ResolveWithFileBase$2((ResourceId)resourceId));
    }

    @Test
    public void testResolveParentToFile() {
        S3ResourceId resourceId = S3ResourceId.fromUri((String)"s3://bucket/path/to/dir/");
        Assert.assertThrows(IllegalArgumentException.class, () -> S3ResourceIdTest.lambda$testResolveParentToFile$3((ResourceId)resourceId));
    }

    @Test
    public void testGetCurrentDirectory() {
        Assert.assertEquals((Object)S3ResourceId.fromUri((String)"s3://my_bucket/tmp dir/"), (Object)S3ResourceId.fromUri((String)"s3://my_bucket/tmp dir/").getCurrentDirectory());
        Assert.assertEquals((Object)S3ResourceId.fromUri((String)"s3://my_bucket/\u8f93\u51fa \u76ee\u5f55/"), (Object)S3ResourceId.fromUri((String)"s3://my_bucket/\u8f93\u51fa \u76ee\u5f55/\u6587\u4ef601.txt").getCurrentDirectory());
        Assert.assertEquals((Object)S3ResourceId.fromUri((String)"s3://my_bucket/"), (Object)S3ResourceId.fromUri((String)"s3://my_bucket").getCurrentDirectory());
        Assert.assertEquals((Object)S3ResourceId.fromUri((String)"s3://my_bucket/"), (Object)S3ResourceId.fromUri((String)"s3://my_bucket/not-directory").getCurrentDirectory());
    }

    @Test
    public void testIsDirectory() {
        Assert.assertTrue((boolean)S3ResourceId.fromUri((String)"s3://my_bucket/tmp dir/").isDirectory());
        Assert.assertTrue((boolean)S3ResourceId.fromUri((String)"s3://my_bucket/").isDirectory());
        Assert.assertTrue((boolean)S3ResourceId.fromUri((String)"s3://my_bucket").isDirectory());
        Assert.assertFalse((boolean)S3ResourceId.fromUri((String)"s3://my_bucket/file").isDirectory());
    }

    @Test
    public void testInvalidPathNoBucket() {
        Assert.assertThrows((String)"Invalid S3 URI: [s3://]", IllegalArgumentException.class, () -> S3ResourceId.fromUri((String)"s3://"));
    }

    @Test
    public void testInvalidPathNoBucketAndSlash() {
        Assert.assertThrows((String)"Invalid S3 URI: [s3:///]", IllegalArgumentException.class, () -> S3ResourceId.fromUri((String)"s3:///"));
    }

    @Test
    public void testGetScheme() {
        Assert.assertEquals((Object)"s3", (Object)S3ResourceId.fromUri((String)"s3://my_bucket/tmp dir/").getScheme());
        Assert.assertEquals((Object)"s3", (Object)S3ResourceId.fromUri((String)"s3://my_bucket").getScheme());
    }

    @Test
    public void testGetFilename() {
        Assert.assertNull((Object)S3ResourceId.fromUri((String)"s3://my_bucket/").getFilename());
        Assert.assertEquals((Object)"abc", (Object)S3ResourceId.fromUri((String)"s3://my_bucket/abc").getFilename());
        Assert.assertEquals((Object)"abc", (Object)S3ResourceId.fromUri((String)"s3://my_bucket/abc/").getFilename());
        Assert.assertEquals((Object)"def", (Object)S3ResourceId.fromUri((String)"s3://my_bucket/abc/def").getFilename());
        Assert.assertEquals((Object)"def", (Object)S3ResourceId.fromUri((String)"s3://my_bucket/abc/def/").getFilename());
        Assert.assertEquals((Object)"xyz.txt", (Object)S3ResourceId.fromUri((String)"s3://my_bucket/abc/xyz.txt").getFilename());
    }

    @Test
    public void testParentRelationship() {
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://bucket/dir/subdir/object");
        Assert.assertEquals((Object)"bucket", (Object)path.getBucket());
        Assert.assertEquals((Object)"dir/subdir/object", (Object)path.getKey());
        path = S3ResourceId.fromUri((String)"s3://bucket/dir/subdir/");
        S3ResourceId parent = (S3ResourceId)path.resolve("..", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY);
        Assert.assertEquals((Object)"bucket", (Object)parent.getBucket());
        Assert.assertEquals((Object)"dir/", (Object)parent.getKey());
        Assert.assertNotEquals((Object)path, (Object)parent);
        Assert.assertTrue((boolean)path.getKey().startsWith(parent.getKey()));
        Assert.assertFalse((boolean)parent.getKey().startsWith(path.getKey()));
        S3ResourceId grandParent = (S3ResourceId)parent.resolve("..", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY);
        Assert.assertEquals((Object)"bucket", (Object)grandParent.getBucket());
        Assert.assertEquals((Object)"", (Object)grandParent.getKey());
    }

    @Test
    public void testBucketParsing() {
        S3ResourceId path = S3ResourceId.fromUri((String)"s3://bucket");
        S3ResourceId path2 = S3ResourceId.fromUri((String)"s3://bucket/");
        Assert.assertEquals((Object)path, (Object)path2);
        Assert.assertEquals((Object)path.toString(), (Object)path2.toString());
    }

    @Test
    public void testS3ResourceIdToString() {
        String filename = "s3://some-bucket/some/file.txt";
        S3ResourceId path = S3ResourceId.fromUri((String)filename);
        Assert.assertEquals((Object)filename, (Object)path.toString());
        filename = "s3://some-bucket/some/";
        path = S3ResourceId.fromUri((String)filename);
        Assert.assertEquals((Object)filename, (Object)path.toString());
        filename = "s3://some-bucket/";
        path = S3ResourceId.fromUri((String)filename);
        Assert.assertEquals((Object)filename, (Object)path.toString());
    }

    @Test
    public void testEquals() {
        S3ResourceId a = S3ResourceId.fromComponents((String)"s3", (String)"bucket", (String)"a/b/c");
        S3ResourceId b = S3ResourceId.fromComponents((String)"s3", (String)"bucket", (String)"a/b/c");
        Assert.assertEquals((Object)a, (Object)b);
        Assert.assertEquals((Object)b, (Object)a);
        b = S3ResourceId.fromComponents((String)"s3", (String)a.getBucket(), (String)"a/b/c/");
        Assert.assertNotEquals((Object)a, (Object)b);
        Assert.assertNotEquals((Object)b, (Object)a);
        b = S3ResourceId.fromComponents((String)"s3", (String)a.getBucket(), (String)"x/y/z");
        Assert.assertNotEquals((Object)a, (Object)b);
        Assert.assertNotEquals((Object)b, (Object)a);
        b = S3ResourceId.fromComponents((String)"s3", (String)"other-bucket", (String)a.getKey());
        Assert.assertNotEquals((Object)a, (Object)b);
        Assert.assertNotEquals((Object)b, (Object)a);
        b = S3ResourceId.fromComponents((String)"other", (String)"bucket", (String)"a/b/c");
        Assert.assertNotEquals((Object)a, (Object)b);
        Assert.assertNotEquals((Object)b, (Object)a);
    }

    @Test
    public void testInvalidBucket() {
        Assert.assertThrows(IllegalArgumentException.class, () -> S3ResourceId.fromComponents((String)"s3", (String)"invalid/", (String)""));
    }

    @Test
    public void testResourceIdTester() {
        S3Options options = (S3Options)PipelineOptionsFactory.create().as(S3Options.class);
        options.setAwsRegion(Region.US_WEST_1);
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
        ResourceIdTester.runResourceIdBattery((ResourceId)S3ResourceId.fromUri((String)"s3://bucket/foo/"));
    }

    private static /* synthetic */ void lambda$testResolveParentToFile$3(ResourceId resourceId) throws Throwable {
        resourceId.resolve("..", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
    }

    private static /* synthetic */ void lambda$testS3ResolveWithFileBase$2(ResourceId resourceId) throws Throwable {
        resourceId.resolve("child-path", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY);
    }

    static final class TestCase {
        final String baseUri;
        final String relativePath;
        final ResolveOptions.StandardResolveOptions resolveOptions;
        final String expectedResult;

        TestCase(String baseUri, String relativePath, ResolveOptions.StandardResolveOptions resolveOptions, String expectedResult) {
            this.baseUri = baseUri;
            this.relativePath = relativePath;
            this.resolveOptions = resolveOptions;
            this.expectedResult = expectedResult;
        }
    }
}

