/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.s3;

import java.net.URI;
import org.apache.beam.sdk.io.aws2.common.ClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.options.S3Options;
import org.apache.beam.sdk.io.aws2.s3.DefaultS3ClientBuilderFactory;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultS3ClientBuilderFactoryTest {
    @Mock
    S3Options s3Options;
    @Mock
    S3ClientBuilder builder;

    @Before
    public void prepareOptions() {
        Mockito.when((Object)this.s3Options.getClientBuilderFactory()).thenReturn(ClientBuilderFactory.DefaultClientBuilder.class);
    }

    @Test
    public void testEmptyOptions() {
        DefaultS3ClientBuilderFactory.createBuilder((S3ClientBuilder)this.builder, (S3Options)this.s3Options);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.builder});
    }

    @Test
    public void testSetCredentialsProvider() {
        AwsCredentialsProvider credentialsProvider = (AwsCredentialsProvider)Mockito.mock(AwsCredentialsProvider.class);
        Mockito.when((Object)this.s3Options.getAwsCredentialsProvider()).thenReturn((Object)credentialsProvider);
        DefaultS3ClientBuilderFactory.createBuilder((S3ClientBuilder)this.builder, (S3Options)this.s3Options);
        ((S3ClientBuilder)Mockito.verify((Object)this.builder)).credentialsProvider(credentialsProvider);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.builder});
    }

    @Test
    public void testSetProxyConfiguration() {
        Mockito.when((Object)this.s3Options.getProxyConfiguration()).thenReturn((Object)((ProxyConfiguration)ProxyConfiguration.builder().build()));
        DefaultS3ClientBuilderFactory.createBuilder((S3ClientBuilder)this.builder, (S3Options)this.s3Options);
        ((S3ClientBuilder)Mockito.verify((Object)this.builder)).httpClientBuilder((SdkHttpClient.Builder)ArgumentMatchers.any(ApacheHttpClient.Builder.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.builder});
    }

    @Test
    public void testSetEndpoint() {
        URI endpointOverride = URI.create("https://localhost");
        Mockito.when((Object)this.s3Options.getEndpoint()).thenReturn((Object)endpointOverride);
        DefaultS3ClientBuilderFactory.createBuilder((S3ClientBuilder)this.builder, (S3Options)this.s3Options);
        ((S3ClientBuilder)Mockito.verify((Object)this.builder)).endpointOverride(endpointOverride);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.builder});
    }

    @Test
    public void testSetRegion() {
        Mockito.when((Object)this.s3Options.getAwsRegion()).thenReturn((Object)Region.US_WEST_1);
        DefaultS3ClientBuilderFactory.createBuilder((S3ClientBuilder)this.builder, (S3Options)this.s3Options);
        ((S3ClientBuilder)Mockito.verify((Object)this.builder)).region(Region.US_WEST_1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.builder});
    }
}

