/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.options;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.beam.sdk.util.common.ReflectHelpers;

public class SerializationTestUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));

    public static <T> T serializeDeserialize(Class<T> clazz, T obj) {
        return SerializationTestUtil.deserialize(SerializationTestUtil.serialize(obj), clazz);
    }

    public static <T> String serialize(T obj) {
        try {
            return MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize " + obj.getClass().getSimpleName(), e);
        }
    }

    public static <T> T deserialize(String jsonString, Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(jsonString, clazz);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize " + clazz.getSimpleName(), e);
        }
    }
}

