/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.options;

import org.apache.beam.sdk.io.aws2.options.S3Options;
import org.apache.beam.sdk.io.aws2.options.SerializationTestUtil;
import org.apache.beam.sdk.io.aws2.s3.DefaultS3ClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.s3.SSECustomerKey;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class S3OptionsTest {
    private S3Options serializeDeserialize(S3Options opts) {
        return (S3Options)((PipelineOptions)SerializationTestUtil.serializeDeserialize(PipelineOptions.class, opts)).as(S3Options.class);
    }

    private S3Options create(String ... args) {
        return (S3Options)PipelineOptionsFactory.fromArgs((String[])args).as(S3Options.class);
    }

    @Test
    public void testSerializeDeserializeDefaults() {
        S3Options options = this.create(new String[0]);
        options.getSSECustomerKey();
        options.getS3UploadBufferSizeBytes();
        S3Options copy = this.serializeDeserialize(options);
        Assertions.assertThat((String)copy.getS3StorageClass()).isEqualTo((Object)options.getS3StorageClass());
        Assertions.assertThat((Integer)copy.getS3UploadBufferSizeBytes()).isEqualTo((Object)options.getS3UploadBufferSizeBytes());
        Assertions.assertThat((int)copy.getS3ThreadPoolSize()).isEqualTo(options.getS3ThreadPoolSize());
        Assertions.assertThat((Object)copy.getSSECustomerKey()).isEqualToComparingFieldByField((Object)options.getSSECustomerKey());
        Assertions.assertThat((Class)copy.getS3ClientFactoryClass()).isEqualTo((Object)options.getS3ClientFactoryClass());
        Assertions.assertThat((String)copy.getSSEKMSKeyId()).isNull();
        Assertions.assertThat((String)options.getSSEKMSKeyId()).isNull();
        Assertions.assertThat((String)copy.getSSEAlgorithm()).isNull();
        Assertions.assertThat((String)options.getSSEAlgorithm()).isNull();
    }

    @Test
    public void testSetS3StorageClass() {
        S3Options options = this.create("--s3StorageClass=GLACIER");
        Assertions.assertThat((String)options.getS3StorageClass()).isEqualTo((Object)"GLACIER");
        Assertions.assertThat((String)this.serializeDeserialize(options).getS3StorageClass()).isEqualTo((Object)"GLACIER");
    }

    @Test
    public void testSetS3UploadBufferSizeBytes() {
        S3Options options = this.create("--s3UploadBufferSizeBytes=1024");
        Assertions.assertThat((Integer)options.getS3UploadBufferSizeBytes()).isEqualTo(1024);
        Assertions.assertThat((Integer)this.serializeDeserialize(options).getS3UploadBufferSizeBytes()).isEqualTo(1024);
    }

    @Test
    public void testSetS3ThreadPoolSize() {
        S3Options options = this.create("--s3ThreadPoolSize=10");
        Assertions.assertThat((int)options.getS3ThreadPoolSize()).isEqualTo(10);
        Assertions.assertThat((int)this.serializeDeserialize(options).getS3ThreadPoolSize()).isEqualTo(10);
    }

    @Test
    public void testSetSSEAlgorithm() {
        S3Options options = this.create("--SSEAlgorithm=AES256");
        Assertions.assertThat((String)options.getSSEAlgorithm()).isEqualTo((Object)"AES256");
        Assertions.assertThat((String)this.serializeDeserialize(options).getSSEAlgorithm()).isEqualTo((Object)"AES256");
    }

    @Test
    public void testSetSSECustomerKey() {
        S3Options options = this.create("--SSECustomerKey={\"key\": \"key\", \"algorithm\": \"algo\"}");
        SSECustomerKey expected = SSECustomerKey.builder().key("key").algorithm("algo").build();
        Assertions.assertThat((Object)options.getSSECustomerKey()).isEqualToComparingFieldByField((Object)expected);
        Assertions.assertThat((Object)this.serializeDeserialize(options).getSSECustomerKey()).isEqualToComparingFieldByField((Object)expected);
    }

    @Test
    public void testSetSSEKMSKeyId() {
        S3Options options = this.create("--SSEKMSKeyId=arnOfKey");
        Assertions.assertThat((String)options.getSSEKMSKeyId()).isEqualTo((Object)"arnOfKey");
        Assertions.assertThat((String)this.serializeDeserialize(options).getSSEKMSKeyId()).isEqualTo((Object)"arnOfKey");
    }

    @Test
    public void testSetS3ClientFactoryClass() {
        S3Options options = this.create("--s3ClientFactoryClass=" + NoopS3ClientBuilderFactory.class.getName());
        Assertions.assertThat((Class)options.getS3ClientFactoryClass()).isEqualTo(NoopS3ClientBuilderFactory.class);
        Assertions.assertThat((Class)this.serializeDeserialize(options).getS3ClientFactoryClass()).isEqualTo(NoopS3ClientBuilderFactory.class);
    }

    public static class NoopS3ClientBuilderFactory
    extends DefaultS3ClientBuilderFactory {
    }
}

