/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.options;

import java.net.URI;
import java.util.function.Supplier;
import org.apache.beam.sdk.io.aws2.common.HttpClientConfiguration;
import org.apache.beam.sdk.io.aws2.options.AwsOptions;
import org.apache.beam.sdk.io.aws2.options.SerializationTestUtil;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;

public class AwsOptionsTest {
    private AwsOptions serializeDeserialize(AwsOptions opts) {
        return (AwsOptions)((PipelineOptions)SerializationTestUtil.serializeDeserialize(PipelineOptions.class, opts)).as(AwsOptions.class);
    }

    private AwsOptions create(String ... args) {
        return (AwsOptions)PipelineOptionsFactory.fromArgs((String[])args).as(AwsOptions.class);
    }

    @Test
    public void testSerializeDeserializeDefaults() {
        AwsOptions options = this.create(new String[0]);
        Assertions.assertThat((Object)this.withRegionProperty(Region.US_WEST_1, () -> options.getAwsRegion())).isEqualTo((Object)Region.US_WEST_1);
        Assertions.assertThat((Object)options.getAwsCredentialsProvider()).isEqualTo((Object)DefaultCredentialsProvider.create());
        AwsOptions copy = this.serializeDeserialize(options);
        Assertions.assertThat((Object)copy.getAwsRegion()).isEqualTo((Object)options.getAwsRegion());
        Assertions.assertThat((Object)copy.getAwsCredentialsProvider()).isEqualTo((Object)options.getAwsCredentialsProvider());
        Assertions.assertThat((URI)copy.getEndpoint()).isNull();
        Assertions.assertThat((URI)options.getEndpoint()).isNull();
        Assertions.assertThat((Object)copy.getProxyConfiguration()).isNull();
        Assertions.assertThat((Object)options.getProxyConfiguration()).isNull();
        Assertions.assertThat((Object)copy.getHttpClientConfiguration()).isNull();
        Assertions.assertThat((Object)options.getHttpClientConfiguration()).isNull();
    }

    @Test
    public void testSetAwsRegion() {
        AwsOptions options = this.create("--awsRegion=us-west-1");
        Assertions.assertThat((Object)options.getAwsRegion()).isEqualTo((Object)Region.US_WEST_1);
        Assertions.assertThat((Object)this.serializeDeserialize(options).getAwsRegion()).isEqualTo((Object)Region.US_WEST_1);
    }

    @Test
    public void testSetAwsCredentialsProvider() {
        AwsOptions options = this.create("--awsCredentialsProvider={\"@type\":\"StaticCredentialsProvider\",\"accessKeyId\":\"key\",\"secretAccessKey\":\"secret\"}");
        StaticCredentialsProvider expected = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)"key", (String)"secret"));
        Assertions.assertThat((Object)options.getAwsCredentialsProvider()).isEqualToComparingFieldByFieldRecursively((Object)expected);
        Assertions.assertThat((Object)this.serializeDeserialize(options).getAwsCredentialsProvider()).isEqualToComparingFieldByFieldRecursively((Object)expected);
    }

    @Test
    public void testSetEndpoint() {
        AwsOptions options = this.create("--endpoint=https://localhost:8080");
        Assertions.assertThat((URI)options.getEndpoint()).isEqualTo((Object)URI.create("https://localhost:8080"));
        Assertions.assertThat((URI)this.serializeDeserialize(options).getEndpoint()).isEqualTo((Object)URI.create("https://localhost:8080"));
    }

    @Test
    public void testSetProxyConfiguration() {
        AwsOptions options = this.create("--proxyConfiguration={\"endpoint\":\"https://localhost:8080\", \"username\":\"user\", \"password\":\"pw\"}");
        ProxyConfiguration expected = (ProxyConfiguration)ProxyConfiguration.builder().endpoint(URI.create("https://localhost:8080")).username("user").password("pw").build();
        Assertions.assertThat((Object)options.getProxyConfiguration()).isEqualToIgnoringGivenFields((Object)expected, new String[]{"useSystemPropertyValues"});
        Assertions.assertThat((Object)this.serializeDeserialize(options).getProxyConfiguration()).isEqualToIgnoringGivenFields((Object)expected, new String[]{"useSystemPropertyValues"});
    }

    @Test
    public void testSetHttpClientConfiguration() {
        AwsOptions options = this.create("--httpClientConfiguration={\"connectionAcquisitionTimeout\":100,\"connectionMaxIdleTime\":200,\"connectionTimeout\":300,\"connectionTimeToLive\":400,\"socketTimeout\":500,\"readTimeout\":600,\"writeTimeout\":700,\"maxConnections\":10}");
        HttpClientConfiguration expected = HttpClientConfiguration.builder().connectionAcquisitionTimeout(Integer.valueOf(100)).connectionMaxIdleTime(Integer.valueOf(200)).connectionTimeout(Integer.valueOf(300)).connectionTimeToLive(Integer.valueOf(400)).socketTimeout(Integer.valueOf(500)).readTimeout(Integer.valueOf(600)).writeTimeout(Integer.valueOf(700)).maxConnections(Integer.valueOf(10)).build();
        Assertions.assertThat((Object)options.getHttpClientConfiguration()).isEqualTo((Object)expected);
        Assertions.assertThat((Object)this.serializeDeserialize(options).getHttpClientConfiguration()).isEqualTo((Object)expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withRegionProperty(Region region, Supplier<T> fun) {
        String oldRegion = System.getProperty(SdkSystemSetting.AWS_REGION.property());
        System.setProperty(SdkSystemSetting.AWS_REGION.property(), region.id());
        try {
            T t = fun.get();
            return t;
        }
        finally {
            if (oldRegion == null) {
                System.clearProperty(SdkSystemSetting.AWS_REGION.property());
            } else {
                System.setProperty(SdkSystemSetting.AWS_REGION.property(), oldRegion);
            }
        }
    }
}

