/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.options;

import com.amazonaws.regions.Regions;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.beam.sdk.io.aws2.options.AwsModule;
import org.apache.beam.sdk.io.aws2.options.SerializationTestUtil;
import org.apache.beam.sdk.testing.ExpectedLogs;
import org.apache.beam.sdk.util.ThrowingSupplier;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExternalResource;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.auth.credentials.SystemPropertyCredentialsProvider;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleWithWebIdentityCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;

@RunWith(value=JUnit4.class)
public class AwsModuleTest {
    @ClassRule
    public static final ProfileFile PROFILE = new ProfileFile("[default]", "aws_access_key_id=defaultkey", "aws_secret_access_key=123", "[profile other]", "aws_access_key_id=otherkey", "aws_secret_access_key=abc");
    private static final AwsCredentials DEFAULT_CREDENTIALS = AwsBasicCredentials.create((String)"defaultkey", (String)"123");
    private static final AwsCredentials OTHER_CREDENTIALS = AwsBasicCredentials.create((String)"otherkey", (String)"abc");
    @Rule
    public final ExpectedLogs logs = ExpectedLogs.none(AwsModule.class);

    @Test
    public void testObjectMapperIsAbleToFindModule() {
        List modules = ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader());
        MatcherAssert.assertThat((Object)modules, (Matcher)Matchers.hasItem((Matcher)Matchers.instanceOf(AwsModule.class)));
    }

    private <T> T serializeAndDeserialize(T obj) {
        return (T)SerializationTestUtil.serializeDeserialize(obj.getClass(), obj);
    }

    @Test
    public void testStaticCredentialsProviderSerDe() {
        StaticCredentialsProvider provider = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)"key", (String)"secret"));
        ((ObjectAssert)Assertions.assertThat((Object)((AwsCredentialsProvider)this.serializeAndDeserialize(provider))).hasSameClassAs((Object)provider)).isEqualToComparingFieldByFieldRecursively((Object)provider);
        provider = StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)"key", (String)"secret", (String)"token"));
        ((ObjectAssert)Assertions.assertThat((Object)((AwsCredentialsProvider)this.serializeAndDeserialize(provider))).hasSameClassAs((Object)provider)).isEqualToComparingFieldByFieldRecursively((Object)provider);
    }

    @Test
    public void testAwsCredentialsProviderSerDe() {
        DefaultCredentialsProvider provider = DefaultCredentialsProvider.create();
        AwsCredentialsProvider deserializedProvider = (AwsCredentialsProvider)this.serializeAndDeserialize(provider);
        Assert.assertEquals(provider.getClass(), deserializedProvider.getClass());
        provider = EnvironmentVariableCredentialsProvider.create();
        deserializedProvider = (AwsCredentialsProvider)this.serializeAndDeserialize(provider);
        Assert.assertEquals(provider.getClass(), deserializedProvider.getClass());
        provider = SystemPropertyCredentialsProvider.create();
        deserializedProvider = (AwsCredentialsProvider)this.serializeAndDeserialize(provider);
        Assert.assertEquals(provider.getClass(), deserializedProvider.getClass());
        provider = ContainerCredentialsProvider.builder().build();
        deserializedProvider = (AwsCredentialsProvider)this.serializeAndDeserialize(provider);
        Assert.assertEquals(provider.getClass(), deserializedProvider.getClass());
    }

    @Test
    public void testProfileCredentialsProviderSerDeWithDefaultProfile() throws Exception {
        this.withSystemProperties(PROFILE.properties("default"), () -> {
            ProfileCredentialsProvider provider = ProfileCredentialsProvider.create();
            String serializedProvider = SerializationTestUtil.serialize(provider);
            Assertions.assertThat((String)serializedProvider).isEqualTo((Object)"{\"@type\":\"ProfileCredentialsProvider\"}");
            AwsCredentialsProvider actual = AwsModuleTest.deserialize(serializedProvider);
            ((ObjectAssert)Assertions.assertThat((Object)actual).isExactlyInstanceOf(ProfileCredentialsProvider.class)).isEqualToComparingFieldByFieldRecursively((Object)provider);
            return (ObjectAssert)Assertions.assertThat((Object)actual.resolveCredentials()).isEqualToComparingFieldByField((Object)DEFAULT_CREDENTIALS);
        });
    }

    @Test
    public void testProfileCredentialsProviderSerDeWithCustomProfile() throws Exception {
        this.withSystemProperties(PROFILE.properties("default"), () -> {
            ProfileCredentialsProvider provider = ProfileCredentialsProvider.create((String)"other");
            String serializedProvider = SerializationTestUtil.serialize(provider);
            Assertions.assertThat((String)serializedProvider).isEqualTo((Object)"{\"@type\":\"ProfileCredentialsProvider\",\"profileName\":\"other\"}");
            AwsCredentialsProvider actual = AwsModuleTest.deserialize(serializedProvider);
            ((ObjectAssert)Assertions.assertThat((Object)actual).isExactlyInstanceOf(ProfileCredentialsProvider.class)).isEqualToComparingFieldByFieldRecursively((Object)provider);
            return (ObjectAssert)Assertions.assertThat((Object)actual.resolveCredentials()).isEqualToComparingFieldByField((Object)OTHER_CREDENTIALS);
        });
    }

    @Test
    public void testProfileCredentialsProviderSerDeWithCustomDefaultProfile() throws Exception {
        this.withSystemProperties(PROFILE.properties("other"), () -> {
            ProfileCredentialsProvider provider = ProfileCredentialsProvider.create((String)"other");
            String serializedProvider = SerializationTestUtil.serialize(provider);
            Assertions.assertThat((String)serializedProvider).isEqualTo((Object)"{\"@type\":\"ProfileCredentialsProvider\"}");
            AwsCredentialsProvider actual = AwsModuleTest.deserialize(serializedProvider);
            ((ObjectAssert)Assertions.assertThat((Object)actual).isExactlyInstanceOf(ProfileCredentialsProvider.class)).isEqualToComparingFieldByFieldRecursively((Object)provider);
            return (ObjectAssert)Assertions.assertThat((Object)actual.resolveCredentials()).isEqualToComparingFieldByFieldRecursively((Object)OTHER_CREDENTIALS);
        });
    }

    @Test
    public void testProfileCredentialsProviderSerDeWithUnknownProfile() throws Exception {
        this.withSystemProperties(PROFILE.properties("default"), () -> {
            ProfileCredentialsProvider provider = ProfileCredentialsProvider.create((String)"unknown");
            String serializedProvider = SerializationTestUtil.serialize(provider);
            Assertions.assertThat((String)serializedProvider).isEqualTo((Object)"{\"@type\":\"ProfileCredentialsProvider\",\"profileName\":\"unknown\"}");
            AwsCredentialsProvider actual = AwsModuleTest.deserialize(serializedProvider);
            ((ObjectAssert)Assertions.assertThat((Object)actual).isExactlyInstanceOf(ProfileCredentialsProvider.class)).isEqualToComparingFieldByFieldRecursively((Object)provider);
            return ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> actual.resolveCredentials()).isInstanceOf(SdkClientException.class)).hasMessageContaining("Profile file contained no credentials for profile 'unknown'");
        });
    }

    @Test
    public void testStsAssumeRoleCredentialsProviderSerDe() throws Exception {
        AssumeRoleRequest req = (AssumeRoleRequest)AssumeRoleRequest.builder().roleArn("roleArn").policy("policy").build();
        Supplier<AwsCredentialsProvider> provider = () -> ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(StsClient.create())).refreshRequest(req).build();
        Properties overrides = new Properties();
        overrides.setProperty(SdkSystemSetting.AWS_REGION.property(), Regions.US_EAST_1.getName());
        overrides.setProperty(SdkSystemSetting.AWS_ACCESS_KEY_ID.property(), "key");
        overrides.setProperty(SdkSystemSetting.AWS_SECRET_ACCESS_KEY.property(), "secret");
        AwsCredentialsProvider deserializedProvider = (AwsCredentialsProvider)this.withSystemProperties(overrides, () -> this.serializeAndDeserialize((AwsCredentialsProvider)provider.get()));
        Supplier requestSupplier = (Supplier)FieldUtils.readField((Object)deserializedProvider, (String)"assumeRoleRequestSupplier", (boolean)true);
        Assertions.assertThat((Object)((AssumeRoleRequest)requestSupplier.get())).isEqualTo((Object)req);
    }

    @Test
    public void testStsAssumeRoleWithWebIdentityCredentialsProviderSerDe() throws Exception {
        AssumeRoleWithWebIdentityRequest req = (AssumeRoleWithWebIdentityRequest)AssumeRoleWithWebIdentityRequest.builder().roleArn("roleArn").policy("policy").webIdentityToken("idToken").build();
        Supplier<AwsCredentialsProvider> provider = () -> ((StsAssumeRoleWithWebIdentityCredentialsProvider.Builder)StsAssumeRoleWithWebIdentityCredentialsProvider.builder().stsClient((StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().region(Region.AWS_GLOBAL)).credentialsProvider((AwsCredentialsProvider)AnonymousCredentialsProvider.create())).build())).refreshRequest(req).build();
        AwsCredentialsProvider deserializedProvider = this.serializeAndDeserialize(provider.get());
        Supplier requestSupplier = (Supplier)FieldUtils.readField((Object)deserializedProvider, (String)"assumeRoleWithWebIdentityRequest", (boolean)true);
        Assertions.assertThat((Object)((AssumeRoleWithWebIdentityRequest)requestSupplier.get())).isEqualTo((Object)req);
    }

    @Test
    public void testProxyConfigurationSerDe() {
        ProxyConfiguration proxyConfiguration = (ProxyConfiguration)ProxyConfiguration.builder().endpoint(URI.create("http://localhost:8080")).username("username").password("password").build();
        ProxyConfiguration deserializedProxyConfiguration = this.serializeAndDeserialize(proxyConfiguration);
        Assert.assertEquals((Object)"localhost", (Object)deserializedProxyConfiguration.host());
        Assert.assertEquals((long)8080L, (long)deserializedProxyConfiguration.port());
        Assert.assertEquals((Object)"username", (Object)deserializedProxyConfiguration.username());
        Assert.assertEquals((Object)"password", (Object)deserializedProxyConfiguration.password());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withSystemProperties(Properties overrides, ThrowingSupplier<T> fun) throws Exception {
        Properties systemProps = System.getProperties();
        Properties previousProps = new Properties();
        systemProps.entrySet().stream().filter(e -> overrides.containsKey(e.getKey())).forEach(e -> previousProps.put(e.getKey(), e.getValue()));
        overrides.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)systemProps::put));
        try {
            Object object = fun.get();
            return (T)object;
        }
        finally {
            overrides.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)systemProps::remove));
            previousProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)systemProps::put));
        }
    }

    private static AwsCredentialsProvider deserialize(String provider) {
        return SerializationTestUtil.deserialize(provider, AwsCredentialsProvider.class);
    }

    static class ProfileFile
    extends ExternalResource {
        private String[] lines;
        private Path path;

        public ProfileFile(String ... lines) {
            this.lines = lines;
        }

        public Properties properties(String defaultProfile) {
            Properties props = new Properties();
            props.setProperty(ProfileFileSystemSetting.AWS_CONFIG_FILE.property(), this.path.toString());
            props.setProperty(ProfileFileSystemSetting.AWS_PROFILE.property(), defaultProfile);
            return props;
        }

        protected void before() throws Throwable {
            this.path = Files.createTempFile("profile", ".conf", new FileAttribute[0]);
            Files.write(this.path, Arrays.asList(this.lines), new OpenOption[0]);
        }

        protected void after() {
            try {
                Files.delete(this.path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

