/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.time.Instant;
import java.util.stream.Stream;
import org.apache.beam.sdk.io.aws2.kinesis.TimeUtil;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TimeUtilTest {
    @Test
    public void shouldConvertToJodaInstant() {
        Assertions.assertThat((Comparable)TimeUtil.toJoda(null)).isNull();
        Assertions.assertThat((Comparable)TimeUtil.toJoda((Instant)Instant.ofEpochMilli(0L))).isEqualTo((Object)org.joda.time.Instant.ofEpochMilli((long)0L));
    }

    @Test
    public void shouldConvertToJavaInstant() {
        Assertions.assertThat((Instant)TimeUtil.toJava(null)).isNull();
        Assertions.assertThat((Instant)TimeUtil.toJava((org.joda.time.Instant)org.joda.time.Instant.ofEpochMilli((long)0L))).isEqualTo((Object)Instant.ofEpochMilli(0L));
    }

    @Test
    public void shouldGiveMinTs() {
        Assertions.assertThat((Comparable)TimeUtil.minTimestamp((Stream)ImmutableList.of().stream())).isEqualTo((Object)BoundedWindow.TIMESTAMP_MAX_VALUE);
        Assertions.assertThat((Comparable)TimeUtil.minTimestamp((Stream)ImmutableList.of((Object)org.joda.time.Instant.ofEpochMilli((long)1L)).stream())).isEqualTo((Object)org.joda.time.Instant.ofEpochMilli((long)1L));
        Assertions.assertThat((Comparable)TimeUtil.minTimestamp((Stream)ImmutableList.of((Object)org.joda.time.Instant.ofEpochMilli((long)1L), (Object)org.joda.time.Instant.ofEpochMilli((long)2L)).stream())).isEqualTo((Object)org.joda.time.Instant.ofEpochMilli((long)1L));
    }
}

