/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.io.IOException;
import java.util.List;
import org.apache.beam.sdk.io.aws2.kinesis.ShardListingUtils;
import org.apache.beam.sdk.io.aws2.kinesis.StartingPoint;
import org.apache.beam.sdk.io.aws2.kinesis.TimeUtil;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryResponse;
import software.amazon.awssdk.services.kinesis.model.LimitExceededException;
import software.amazon.awssdk.services.kinesis.model.ListShardsRequest;
import software.amazon.awssdk.services.kinesis.model.ListShardsResponse;
import software.amazon.awssdk.services.kinesis.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.kinesis.model.Shard;
import software.amazon.awssdk.services.kinesis.model.ShardFilter;
import software.amazon.awssdk.services.kinesis.model.ShardFilterType;
import software.amazon.awssdk.services.kinesis.model.StreamDescriptionSummary;
import software.amazon.kinesis.common.InitialPositionInStream;

@RunWith(value=MockitoJUnitRunner.class)
public class ShardListingUtilsTest {
    private static final String STREAM = "stream";
    private static final String SHARD_1 = "shard-01";
    private static final String SHARD_2 = "shard-02";
    private static final String SHARD_3 = "shard-03";
    private static final Instant CURRENT_TIMESTAMP = Instant.parse((String)"2000-01-01T15:00:00.000Z");
    @Mock
    private KinesisClient kinesis;

    @After
    public void afterEach() {
        DateTimeUtils.setCurrentMillisSystem();
    }

    @Test
    public void shouldListAllShardsForTrimHorizon() throws Exception {
        Shard shard1 = (Shard)Shard.builder().shardId(SHARD_1).build();
        Shard shard2 = (Shard)Shard.builder().shardId(SHARD_2).build();
        Shard shard3 = (Shard)Shard.builder().shardId(SHARD_3).build();
        ShardFilter shardFilter = (ShardFilter)ShardFilter.builder().type(ShardFilterType.AT_TRIM_HORIZON).build();
        Mockito.when((Object)this.kinesis.listShards((ListShardsRequest)ListShardsRequest.builder().streamName(STREAM).shardFilter(shardFilter).maxResults(Integer.valueOf(1000)).build())).thenReturn((Object)((ListShardsResponse)ListShardsResponse.builder().shards(new Shard[]{shard1, shard2, shard3}).nextToken(null).build()));
        List shards = ShardListingUtils.listShardsAtPoint((KinesisClient)this.kinesis, (String)STREAM, (StartingPoint)new StartingPoint(InitialPositionInStream.TRIM_HORIZON));
        Assertions.assertThat((List)shards).containsOnly((Object[])new Shard[]{shard1, shard2, shard3});
    }

    @Test
    public void shouldListAllShardsForTrimHorizonWithPagedResults() throws Exception {
        Shard shard1 = (Shard)Shard.builder().shardId(SHARD_1).build();
        Shard shard2 = (Shard)Shard.builder().shardId(SHARD_2).build();
        Shard shard3 = (Shard)Shard.builder().shardId(SHARD_3).build();
        ShardFilter shardFilter = (ShardFilter)ShardFilter.builder().type(ShardFilterType.AT_TRIM_HORIZON).build();
        String nextListShardsToken = "testNextToken";
        Mockito.when((Object)this.kinesis.listShards((ListShardsRequest)ListShardsRequest.builder().streamName(STREAM).shardFilter(shardFilter).maxResults(Integer.valueOf(1000)).build())).thenReturn((Object)((ListShardsResponse)ListShardsResponse.builder().shards(new Shard[]{shard1, shard2}).nextToken(nextListShardsToken).build()));
        Mockito.when((Object)this.kinesis.listShards((ListShardsRequest)ListShardsRequest.builder().maxResults(Integer.valueOf(1000)).shardFilter(shardFilter).nextToken(nextListShardsToken).build())).thenReturn((Object)((ListShardsResponse)ListShardsResponse.builder().shards(new Shard[]{shard3}).nextToken(null).build()));
        List shards = ShardListingUtils.listShardsAtPoint((KinesisClient)this.kinesis, (String)STREAM, (StartingPoint)new StartingPoint(InitialPositionInStream.TRIM_HORIZON));
        Assertions.assertThat((List)shards).containsOnly((Object[])new Shard[]{shard1, shard2, shard3});
    }

    @Test
    public void shouldListAllShardsForTimestampWithinStreamRetentionAfterStreamCreationTimestamp() throws Exception {
        Shard shard1 = (Shard)Shard.builder().shardId(SHARD_1).build();
        Shard shard2 = (Shard)Shard.builder().shardId(SHARD_2).build();
        Shard shard3 = (Shard)Shard.builder().shardId(SHARD_3).build();
        int hoursDifference = 1;
        int retentionPeriodHours = hoursDifference * 3;
        Instant streamCreationTimestamp = CURRENT_TIMESTAMP.minus((ReadableDuration)Duration.standardHours((long)retentionPeriodHours));
        Instant startingPointTimestamp = streamCreationTimestamp.plus((ReadableDuration)Duration.standardHours((long)hoursDifference));
        DateTimeUtils.setCurrentMillisFixed((long)CURRENT_TIMESTAMP.getMillis());
        Mockito.when((Object)this.kinesis.describeStreamSummary((DescribeStreamSummaryRequest)DescribeStreamSummaryRequest.builder().streamName(STREAM).build())).thenReturn((Object)((DescribeStreamSummaryResponse)DescribeStreamSummaryResponse.builder().streamDescriptionSummary((StreamDescriptionSummary)StreamDescriptionSummary.builder().retentionPeriodHours(Integer.valueOf(retentionPeriodHours)).streamCreationTimestamp(TimeUtil.toJava((Instant)streamCreationTimestamp)).build()).build()));
        ShardFilter shardFilter = (ShardFilter)ShardFilter.builder().type(ShardFilterType.AT_TIMESTAMP).timestamp(TimeUtil.toJava((Instant)startingPointTimestamp)).build();
        Mockito.when((Object)this.kinesis.listShards((ListShardsRequest)ListShardsRequest.builder().streamName(STREAM).shardFilter(shardFilter).maxResults(Integer.valueOf(1000)).build())).thenReturn((Object)((ListShardsResponse)ListShardsResponse.builder().shards(new Shard[]{shard1, shard2, shard3}).nextToken(null).build()));
        List shards = ShardListingUtils.listShardsAtPoint((KinesisClient)this.kinesis, (String)STREAM, (StartingPoint)new StartingPoint(startingPointTimestamp));
        Assertions.assertThat((List)shards).containsOnly((Object[])new Shard[]{shard1, shard2, shard3});
    }

    @Test
    public void shouldListAllShardsForTimestampWithRetriedDescribeStreamSummaryCallAfterStreamCreationTimestamp() throws IOException, InterruptedException {
        Shard shard1 = (Shard)Shard.builder().shardId(SHARD_1).build();
        Shard shard2 = (Shard)Shard.builder().shardId(SHARD_2).build();
        Shard shard3 = (Shard)Shard.builder().shardId(SHARD_3).build();
        int hoursDifference = 1;
        int retentionPeriodHours = hoursDifference * 3;
        Instant streamCreationTimestamp = CURRENT_TIMESTAMP.minus((ReadableDuration)Duration.standardHours((long)retentionPeriodHours));
        Instant startingPointTimestamp = streamCreationTimestamp.plus((ReadableDuration)Duration.standardHours((long)hoursDifference));
        DateTimeUtils.setCurrentMillisFixed((long)CURRENT_TIMESTAMP.getMillis());
        Mockito.when((Object)this.kinesis.describeStreamSummary((DescribeStreamSummaryRequest)DescribeStreamSummaryRequest.builder().streamName(STREAM).build())).thenThrow(new Throwable[]{(Throwable)LimitExceededException.builder().message("Fake Exception: Limit exceeded").build()}).thenReturn((Object)((DescribeStreamSummaryResponse)DescribeStreamSummaryResponse.builder().streamDescriptionSummary((StreamDescriptionSummary)StreamDescriptionSummary.builder().retentionPeriodHours(Integer.valueOf(retentionPeriodHours)).streamCreationTimestamp(TimeUtil.toJava((Instant)streamCreationTimestamp)).build()).build()));
        ShardFilter shardFilter = (ShardFilter)ShardFilter.builder().type(ShardFilterType.AT_TIMESTAMP).timestamp(TimeUtil.toJava((Instant)startingPointTimestamp)).build();
        Mockito.when((Object)this.kinesis.listShards((ListShardsRequest)ListShardsRequest.builder().streamName(STREAM).shardFilter(shardFilter).maxResults(Integer.valueOf(1000)).build())).thenReturn((Object)((ListShardsResponse)ListShardsResponse.builder().shards(new Shard[]{shard1, shard2, shard3}).nextToken(null).build()));
        List shards = ShardListingUtils.listShardsAtPoint((KinesisClient)this.kinesis, (String)STREAM, (StartingPoint)new StartingPoint(startingPointTimestamp));
        Assertions.assertThat((List)shards).containsOnly((Object[])new Shard[]{shard1, shard2, shard3});
    }

    @Test
    public void shouldListAllShardsForTimestampOutsideStreamRetentionAfterStreamCreationTimestamp() throws Exception {
        Shard shard1 = (Shard)Shard.builder().shardId(SHARD_1).build();
        Shard shard2 = (Shard)Shard.builder().shardId(SHARD_2).build();
        Shard shard3 = (Shard)Shard.builder().shardId(SHARD_3).build();
        int retentionPeriodHours = 3;
        int startingPointHours = 5;
        int hoursSinceStreamCreation = 6;
        Instant streamCreationTimestamp = CURRENT_TIMESTAMP.minus((ReadableDuration)Duration.standardHours((long)hoursSinceStreamCreation));
        Instant startingPointTimestampAfterStreamRetentionTimestamp = CURRENT_TIMESTAMP.minus((ReadableDuration)Duration.standardHours((long)startingPointHours));
        DateTimeUtils.setCurrentMillisFixed((long)CURRENT_TIMESTAMP.getMillis());
        DescribeStreamSummaryRequest describeStreamRequest = (DescribeStreamSummaryRequest)DescribeStreamSummaryRequest.builder().streamName(STREAM).build();
        Mockito.when((Object)this.kinesis.describeStreamSummary(describeStreamRequest)).thenReturn((Object)((DescribeStreamSummaryResponse)DescribeStreamSummaryResponse.builder().streamDescriptionSummary((StreamDescriptionSummary)StreamDescriptionSummary.builder().retentionPeriodHours(Integer.valueOf(retentionPeriodHours)).streamCreationTimestamp(TimeUtil.toJava((Instant)streamCreationTimestamp)).build()).build()));
        ShardFilter shardFilter = (ShardFilter)ShardFilter.builder().type(ShardFilterType.AT_TRIM_HORIZON).build();
        Mockito.when((Object)this.kinesis.listShards((ListShardsRequest)ListShardsRequest.builder().streamName(STREAM).shardFilter(shardFilter).maxResults(Integer.valueOf(1000)).build())).thenReturn((Object)((ListShardsResponse)ListShardsResponse.builder().shards(new Shard[]{shard1, shard2, shard3}).nextToken(null).build()));
        List shards = ShardListingUtils.listShardsAtPoint((KinesisClient)this.kinesis, (String)STREAM, (StartingPoint)new StartingPoint(startingPointTimestampAfterStreamRetentionTimestamp));
        Assertions.assertThat((List)shards).containsOnly((Object[])new Shard[]{shard1, shard2, shard3});
    }

    @Test
    public void shouldListAllShardsForTimestampBeforeStreamCreationTimestamp() throws Exception {
        Shard shard1 = (Shard)Shard.builder().shardId(SHARD_1).build();
        Shard shard2 = (Shard)Shard.builder().shardId(SHARD_2).build();
        Shard shard3 = (Shard)Shard.builder().shardId(SHARD_3).build();
        Instant startingPointTimestamp = Instant.parse((String)"2000-01-01T15:00:00.000Z");
        Instant streamCreationTimestamp = startingPointTimestamp.plus((ReadableDuration)Duration.standardHours((long)1L));
        DescribeStreamSummaryRequest describeStreamRequest = (DescribeStreamSummaryRequest)DescribeStreamSummaryRequest.builder().streamName(STREAM).build();
        Mockito.when((Object)this.kinesis.describeStreamSummary(describeStreamRequest)).thenReturn((Object)((DescribeStreamSummaryResponse)DescribeStreamSummaryResponse.builder().streamDescriptionSummary((StreamDescriptionSummary)StreamDescriptionSummary.builder().streamCreationTimestamp(TimeUtil.toJava((Instant)streamCreationTimestamp)).build()).build()));
        ShardFilter shardFilter = (ShardFilter)ShardFilter.builder().type(ShardFilterType.AT_TRIM_HORIZON).build();
        Mockito.when((Object)this.kinesis.listShards((ListShardsRequest)ListShardsRequest.builder().streamName(STREAM).shardFilter(shardFilter).maxResults(Integer.valueOf(1000)).build())).thenReturn((Object)((ListShardsResponse)ListShardsResponse.builder().shards(new Shard[]{shard1, shard2, shard3}).nextToken(null).build()));
        List shards = ShardListingUtils.listShardsAtPoint((KinesisClient)this.kinesis, (String)STREAM, (StartingPoint)new StartingPoint(startingPointTimestamp));
        Assertions.assertThat((List)shards).containsOnly((Object[])new Shard[]{shard1, shard2, shard3});
    }

    @Test
    public void shouldListAllShardsForLatest() throws Exception {
        Shard shard1 = (Shard)Shard.builder().shardId(SHARD_1).build();
        Shard shard2 = (Shard)Shard.builder().shardId(SHARD_2).build();
        Shard shard3 = (Shard)Shard.builder().shardId(SHARD_3).build();
        Mockito.when((Object)this.kinesis.listShards((ListShardsRequest)ListShardsRequest.builder().streamName(STREAM).shardFilter((ShardFilter)ShardFilter.builder().type(ShardFilterType.AT_LATEST).build()).maxResults(Integer.valueOf(1000)).build())).thenReturn((Object)((ListShardsResponse)ListShardsResponse.builder().shards(new Shard[]{shard1, shard2, shard3}).nextToken(null).build()));
        List shards = ShardListingUtils.listShardsAtPoint((KinesisClient)this.kinesis, (String)STREAM, (StartingPoint)new StartingPoint(InitialPositionInStream.LATEST));
        Assertions.assertThat((List)shards).containsOnly((Object[])new Shard[]{shard1, shard2, shard3});
    }

    @Test
    public void shouldThrowLimitExceededExceptionForShardListing() {
        this.shouldThrowShardListingError((Exception)LimitExceededException.builder().build(), LimitExceededException.class);
    }

    @Test
    public void shouldThrowProvisionedThroughputExceededExceptionForShardListing() {
        this.shouldThrowShardListingError((Exception)ProvisionedThroughputExceededException.builder().build(), ProvisionedThroughputExceededException.class);
    }

    @Test
    public void shouldThrowServiceErrorForShardListing() {
        this.shouldThrowShardListingError((Exception)SdkServiceException.builder().statusCode(504).build(), SdkServiceException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shouldThrowShardListingError(Exception thrownException, Class<? extends Exception> expectedExceptionClass) {
        Mockito.when((Object)this.kinesis.listShards((ListShardsRequest)ArgumentMatchers.any(ListShardsRequest.class))).thenThrow(new Throwable[]{thrownException});
        try {
            ShardListingUtils.listShardsAtPoint((KinesisClient)this.kinesis, (String)STREAM, (StartingPoint)new StartingPoint(InitialPositionInStream.TRIM_HORIZON));
            Assertions.failBecauseExceptionWasNotThrown(expectedExceptionClass);
        }
        catch (Exception e) {
            try {
                Assertions.assertThat((Throwable)e).isExactlyInstanceOf(expectedExceptionClass);
            }
            catch (Throwable throwable) {
                Mockito.reset((Object[])new KinesisClient[]{this.kinesis});
                throw throwable;
            }
            Mockito.reset((Object[])new KinesisClient[]{this.kinesis});
        }
        Mockito.reset((Object[])new KinesisClient[]{this.kinesis});
    }
}

