/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.beam.sdk.io.aws2.kinesis.RecordsAggregator;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.junit.Test;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry;
import software.amazon.kinesis.retrieval.AggregatorUtil;
import software.amazon.kinesis.retrieval.KinesisClientRecord;

public class RecordsAggregatorTest {
    private static final String PARTITION_KEY = "pk";
    private static final int PARTITION_KEY_OVERHEAD = 2 + "pk".length();
    private static final String HASH_KEY = "12345";
    private static final int HASH_KEY_OVERHEAD = 2 + "12345".length();
    private RecordsAggregator aggregator = new RecordsAggregator(0x100000, new Instant());

    @Test
    public void testAggregationCompatibilityWithKcl() {
        LongStream.range(0L, 1000L).forEach(n -> this.aggregator.addRecord(PARTITION_KEY, HASH_KEY, this.getBytes(n)));
        byte[] aggBytes = this.aggregator.toBytes();
        KinesisClientRecord aggRecord = this.recordBuilder(aggBytes).build();
        List expectedRecords = LongStream.range(0L, 1000L).mapToObj(n -> this.recordBuilder(this.getBytes(n)).aggregated(true).subSequenceNumber(n).build()).collect(Collectors.toList());
        List records = new AggregatorUtil().deaggregate((List)ImmutableList.of((Object)aggRecord));
        Assertions.assertThat((List)records).hasSize(1000);
        Assertions.assertThat((List)records).containsExactlyElementsOf(expectedRecords);
        Assertions.assertThat((int)this.aggregator.getRecordsCount()).isEqualTo(1000);
        Assertions.assertThat((int)this.aggregator.getSizeBytes()).isEqualTo(aggBytes.length);
    }

    @Test
    public void testGetRequestEntryAndReset() {
        LongStream.range(0L, 1000L).forEach(n -> this.aggregator.addRecord(PARTITION_KEY, null, this.getBytes(n)));
        byte[] aggBytes = this.aggregator.toBytes();
        Instant timeout = this.aggregator.timeout();
        PutRecordsRequestEntry reqEntry = this.aggregator.getAndReset(timeout.plus((ReadableDuration)Duration.millis((long)100L)));
        Assertions.assertThat((Comparable)this.aggregator.timeout()).isEqualTo((Object)timeout.plus((ReadableDuration)Duration.millis((long)100L)));
        Assertions.assertThat((String)reqEntry.partitionKey()).isEqualTo((Object)PARTITION_KEY);
        Assertions.assertThat((byte[])reqEntry.data().asByteArrayUnsafe()).isEqualTo((Object)aggBytes);
        Assertions.assertThat((int)this.aggregator.getRecordsCount()).isEqualTo(0);
        Assertions.assertThat((byte[])this.aggregator.toBytes()).hasSize(RecordsAggregator.BASE_OVERHEAD);
        Assertions.assertThat((int)this.aggregator.getSizeBytes()).isEqualTo(RecordsAggregator.BASE_OVERHEAD);
    }

    @Test
    public void testSizeIncrementOfKey() {
        int increment = this.aggregator.sizeIncrement(PARTITION_KEY, null, null);
        System.out.println(increment);
        this.aggregator.addRecord(PARTITION_KEY, null, null);
        System.out.println(this.aggregator.sizeIncrement(PARTITION_KEY, null, null));
        Assertions.assertThat((int)(increment - this.aggregator.sizeIncrement(PARTITION_KEY, null, null))).isEqualTo(PARTITION_KEY_OVERHEAD);
        increment = this.aggregator.sizeIncrement(PARTITION_KEY, HASH_KEY, null);
        this.aggregator.addRecord(PARTITION_KEY, HASH_KEY, null);
        Assertions.assertThat((int)(increment - this.aggregator.sizeIncrement(PARTITION_KEY, HASH_KEY, null))).isEqualTo(HASH_KEY_OVERHEAD);
    }

    @Test
    public void testSizeIncrement() {
        String data;
        String ehk;
        String pk;
        Random rnd = new Random();
        List keys = Stream.generate(() -> RandomStringUtils.randomAscii((int)1, (int)256)).limit(3L).collect(Collectors.toList());
        List hashKeys = Stream.generate(() -> RandomStringUtils.randomNumeric((int)1, (int)38)).limit(3L).collect(Collectors.toList());
        hashKeys.add(null);
        int sizeBytes = RecordsAggregator.BASE_OVERHEAD;
        int increment = 0;
        do {
            int currentBytes = this.aggregator.toBytes().length;
            Assertions.assertThat((int)increment).isEqualTo(currentBytes - sizeBytes);
            Assertions.assertThat((int)this.aggregator.getSizeBytes()).isEqualTo(currentBytes);
            sizeBytes = currentBytes;
            pk = (String)keys.get(rnd.nextInt(keys.size()));
            ehk = (String)hashKeys.get(rnd.nextInt(hashKeys.size()));
            data = RandomStringUtils.randomAscii((int)256, (int)512);
            increment = this.aggregator.sizeIncrement(pk, ehk, data.getBytes(StandardCharsets.UTF_8));
        } while (this.aggregator.addRecord(pk, ehk, data.getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    public void testRejectRecordIfSizeExceeded() {
        this.aggregator = new RecordsAggregator(RecordsAggregator.BASE_OVERHEAD + PARTITION_KEY_OVERHEAD + 100, new Instant());
        Assertions.assertThat((boolean)this.aggregator.addRecord(PARTITION_KEY, null, new byte[95])).isFalse();
        Assertions.assertThat((boolean)this.aggregator.addRecord(PARTITION_KEY, null, new byte[94])).isTrue();
    }

    @Test
    public void testHasCapacity() {
        this.aggregator = new RecordsAggregator(RecordsAggregator.BASE_OVERHEAD + PARTITION_KEY_OVERHEAD + 100, new Instant());
        Assertions.assertThat((boolean)this.aggregator.addRecord(PARTITION_KEY, null, new byte[30])).isTrue();
        Assertions.assertThat((boolean)this.aggregator.hasCapacity()).isTrue();
        Assertions.assertThat((boolean)this.aggregator.addRecord(PARTITION_KEY, null, new byte[30])).isTrue();
        Assertions.assertThat((boolean)this.aggregator.hasCapacity()).isFalse();
        Assertions.assertThat((boolean)this.aggregator.addRecord(PARTITION_KEY, null, new byte[30])).isFalse();
    }

    private byte[] getBytes(long n) {
        return ByteBuffer.allocate(8).putLong(n).array();
    }

    private KinesisClientRecord.KinesisClientRecordBuilder recordBuilder(byte[] bytes) {
        return KinesisClientRecord.builder().partitionKey(PARTITION_KEY).explicitHashKey(HASH_KEY).data(ByteBuffer.wrap(bytes));
    }
}

