/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.util.List;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisClientThrottledException;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.aws2.kinesis.RateLimitPolicyFactory;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.assertj.core.api.Assertions;
import org.joda.time.Duration;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RateLimitPolicyFactoryTest {
    @Test
    public void defaultRateLimiterShouldUseBackoffs() throws Exception {
        Assertions.assertThat((Object)RateLimitPolicyFactory.withDefaultRateLimiter().getRateLimitPolicy()).isInstanceOf(RateLimitPolicyFactory.DefaultRateLimiter.class);
        Assertions.assertThat((Object)RateLimitPolicyFactory.withDefaultRateLimiter((Duration)Duration.millis((long)1L), (Duration)Duration.millis((long)1L), (Duration)Duration.millis((long)1L)).getRateLimitPolicy()).isInstanceOf(RateLimitPolicyFactory.DefaultRateLimiter.class);
        Sleeper sleeper = (Sleeper)Mockito.mock(Sleeper.class);
        BackOff emptySuccess = (BackOff)Mockito.mock(BackOff.class);
        BackOff throttled = (BackOff)Mockito.mock(BackOff.class);
        RateLimitPolicyFactory.DefaultRateLimiter policy = new RateLimitPolicyFactory.DefaultRateLimiter(emptySuccess, throttled, sleeper);
        policy.onSuccess((List)ImmutableList.of((Object)((KinesisRecord)Mockito.mock(KinesisRecord.class))));
        ((BackOff)Mockito.verify((Object)emptySuccess)).reset();
        ((BackOff)Mockito.verify((Object)throttled)).reset();
        Mockito.verifyNoInteractions((Object[])new Object[]{sleeper});
        Mockito.clearInvocations((Object[])new BackOff[]{emptySuccess, throttled});
        Mockito.when((Object)emptySuccess.nextBackOffMillis()).thenReturn((Object)88L, (Object[])new Long[]{99L});
        policy.onSuccess((List)ImmutableList.of());
        policy.onSuccess((List)ImmutableList.of());
        ((BackOff)Mockito.verify((Object)emptySuccess, (VerificationMode)Mockito.times((int)2))).nextBackOffMillis();
        ((BackOff)Mockito.verify((Object)throttled, (VerificationMode)Mockito.times((int)2))).reset();
        ((Sleeper)Mockito.verify((Object)sleeper)).sleep(88L);
        ((Sleeper)Mockito.verify((Object)sleeper)).sleep(99L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{sleeper, throttled, emptySuccess});
        Mockito.clearInvocations((Object[])new Object[]{emptySuccess, throttled, sleeper});
        Mockito.when((Object)throttled.nextBackOffMillis()).thenReturn((Object)111L, (Object[])new Long[]{222L});
        policy.onThrottle((KinesisClientThrottledException)Mockito.mock(KinesisClientThrottledException.class));
        policy.onThrottle((KinesisClientThrottledException)Mockito.mock(KinesisClientThrottledException.class));
        ((BackOff)Mockito.verify((Object)throttled, (VerificationMode)Mockito.times((int)2))).nextBackOffMillis();
        ((Sleeper)Mockito.verify((Object)sleeper)).sleep(111L);
        ((Sleeper)Mockito.verify((Object)sleeper)).sleep(222L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{sleeper, throttled, emptySuccess});
    }
}

