/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.common.TestRow;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Streams;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResultEntry;

public abstract class PutRecordsHelpers {
    protected static final String ERROR_CODE = "ProvisionedThroughputExceededException";
    PutRecordsResponse successResponse = (PutRecordsResponse)PutRecordsResponse.builder().build();

    protected PutRecordsRequest anyRequest() {
        return (PutRecordsRequest)ArgumentMatchers.any();
    }

    protected ArgumentMatcher<PutRecordsRequest> containsAll(Iterable<TestRow> rows) {
        return req -> req.records().containsAll(this.fromTestRows(rows));
    }

    protected ArgumentMatcher<PutRecordsRequest> hasSize(int size) {
        return req -> req.records().size() == size;
    }

    protected ArgumentMatcher<PutRecordsRequest> hasRecordSize(int bytes) {
        return req -> req.records().stream().allMatch(e -> PutRecordsHelpers.bytesOf(e.data()).length == bytes);
    }

    protected ArgumentMatcher<PutRecordsRequest> hasPartitions(String ... partitions) {
        return req -> this.hasSize(partitions.length).matches(req) && Lists.transform((List)req.records(), r -> r.partitionKey()).containsAll(Arrays.asList(partitions));
    }

    protected ArgumentMatcher<PutRecordsRequest> hasExplicitPartitions(String ... partitions) {
        return req -> this.hasSize(partitions.length).matches(req) && Lists.transform((List)req.records(), r -> r.explicitHashKey()).containsAll(Arrays.asList(partitions));
    }

    protected PutRecordsResponse partialSuccessResponse(int successes, int errors) {
        PutRecordsResultEntry e = (PutRecordsResultEntry)PutRecordsResultEntry.builder().errorCode(ERROR_CODE).build();
        PutRecordsResultEntry s = (PutRecordsResultEntry)PutRecordsResultEntry.builder().build();
        return (PutRecordsResponse)PutRecordsResponse.builder().records((Collection)Lists.newArrayList((Iterable)Iterables.concat((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new PutRecordsResultEntry[]{s}), (int)successes), (Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new PutRecordsResultEntry[]{e}), (int)errors)))).build();
    }

    protected TestRow toTestRow(PutRecordsRequestEntry record) {
        int id = ByteBuffer.wrap(PutRecordsHelpers.bytesOf(record.data())).getInt();
        return TestRow.create((Integer)id, (String)record.partitionKey());
    }

    protected List<PutRecordsRequestEntry> fromTestRows(Iterable<TestRow> rows) {
        return Streams.stream(rows).map(this::fromTestRow).collect(Collectors.toList());
    }

    protected PutRecordsRequestEntry fromTestRow(TestRow row) {
        return (PutRecordsRequestEntry)PutRecordsRequestEntry.builder().partitionKey(row.name()).data(SdkBytes.fromByteArray((byte[])PutRecordsHelpers.bytesOf(row.id()))).build();
    }

    private static byte[] bytesOf(SdkBytes data) {
        return data.asByteArrayUnsafe();
    }

    protected static byte[] bytesOf(int n) {
        return ByteBuffer.allocate(4).putInt(n).array();
    }
}

