/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisReaderCheckpoint;
import org.apache.beam.sdk.io.aws2.kinesis.ShardCheckpoint;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;

public class KinesisReaderCheckpointTest {
    private static final String OLDER_VERSION_SERIALIZED_CHECKPOINT = "rO0ABXNyADtvcmcuYXBhY2hlLmJlYW0uc2RrLmlvLmF3czIua2luZXNpcy5LaW5lc2lzUmVhZGVyQ2hlY2twb2ludKHLb3bO/6XJAgABTAAQc2hhcmRDaGVja3BvaW50c3QAEExqYXZhL3V0aWwvTGlzdDt4cHNyAF9vcmcuYXBhY2hlLmJlYW0udmVuZG9yLmd1YXZhLnYzMl8xXzJfanJlLmNvbS5nb29nbGUuY29tbW9uLmNvbGxlY3QuSW1tdXRhYmxlTGlzdCRTZXJpYWxpemVkRm9ybQAAAAAAAAAAAgABWwAIZWxlbWVudHN0ABNbTGphdmEvbGFuZy9PYmplY3Q7eHB1cgATW0xqYXZhLmxhbmcuT2JqZWN0O5DOWJ8QcylsAgAAeHAAAAABc3IAM29yZy5hcGFjaGUuYmVhbS5zZGsuaW8uYXdzMi5raW5lc2lzLlNoYXJkQ2hlY2twb2ludAFv1e9R2rUHAgAGTAAOc2VxdWVuY2VOdW1iZXJ0ABJMamF2YS9sYW5nL1N0cmluZztMAAdzaGFyZElkcQB+AAlMABFzaGFyZEl0ZXJhdG9yVHlwZXQAQUxzb2Z0d2FyZS9hbWF6b24vYXdzc2RrL3NlcnZpY2VzL2tpbmVzaXMvbW9kZWwvU2hhcmRJdGVyYXRvclR5cGU7TAAKc3RyZWFtTmFtZXEAfgAJTAARc3ViU2VxdWVuY2VOdW1iZXJ0ABBMamF2YS9sYW5nL0xvbmc7TAAJdGltZXN0YW1wdAAXTG9yZy9qb2RhL3RpbWUvSW5zdGFudDt4cHQAAjQydAAJc2hhcmQtMDAwfnIAP3NvZnR3YXJlLmFtYXpvbi5hd3NzZGsuc2VydmljZXMua2luZXNpcy5tb2RlbC5TaGFyZEl0ZXJhdG9yVHlwZQAAAAAAAAAAEgAAeHIADmphdmEubGFuZy5FbnVtAAAAAAAAAAASAAB4cHQAFUFGVEVSX1NFUVVFTkNFX05VTUJFUnQACXN0cmVhbS0wMXNyAA5qYXZhLmxhbmcuTG9uZzuL5JDMjyPfAgABSgAFdmFsdWV4cgAQamF2YS5sYW5nLk51bWJlcoaslR0LlOCLAgAAeHAAAAAAAAAADHA=";
    private ShardCheckpoint a = new ShardCheckpoint("stream-01", "shard-000", ShardIteratorType.AFTER_SEQUENCE_NUMBER, "40", Long.valueOf(12L));
    private ShardCheckpoint b = new ShardCheckpoint("stream-01", "shard-001", ShardIteratorType.AFTER_SEQUENCE_NUMBER, "41", Long.valueOf(12L));
    private ShardCheckpoint c = new ShardCheckpoint("stream-01", "shard-002", ShardIteratorType.AFTER_SEQUENCE_NUMBER, "42", Long.valueOf(12L));

    @Test
    public void splitsCheckpointAccordingly() {
        KinesisReaderCheckpoint checkpoint = new KinesisReaderCheckpoint(Arrays.asList(this.a, this.b, this.c));
        this.verifySplitInto(checkpoint, 1);
        this.verifySplitInto(checkpoint, 2);
        this.verifySplitInto(checkpoint, 3);
        this.verifySplitInto(checkpoint, 4);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void isImmutable() {
        KinesisReaderCheckpoint checkpoint = new KinesisReaderCheckpoint(Arrays.asList(this.a, this.b, this.c));
        Iterator iterator = checkpoint.iterator();
        iterator.remove();
    }

    @Test
    public void testJavaSerialization() throws IOException, ClassNotFoundException {
        ShardCheckpoint shardCheckpoint = new ShardCheckpoint("stream-01", "shard-000", ShardIteratorType.AFTER_SEQUENCE_NUMBER, "42", Long.valueOf(12L));
        KinesisReaderCheckpoint checkpoint = new KinesisReaderCheckpoint((Iterable)ImmutableList.of((Object)shardCheckpoint));
        String serializedCheckpoint = KinesisReaderCheckpointTest.serializeObjectToString((Serializable)checkpoint);
        KinesisReaderCheckpoint deserializedCheckpoint = (KinesisReaderCheckpoint)KinesisReaderCheckpointTest.deSerializeObjectFromString(serializedCheckpoint);
        Assertions.assertThat((Iterable)checkpoint).containsExactlyInAnyOrder((Object[])new ShardCheckpoint[]{shardCheckpoint});
        Assertions.assertThat((Iterable)deserializedCheckpoint).containsExactlyInAnyOrder((Object[])new ShardCheckpoint[]{shardCheckpoint});
        try {
            KinesisReaderCheckpoint olderVersionDeserializedCheckpoint = (KinesisReaderCheckpoint)KinesisReaderCheckpointTest.deSerializeObjectFromString(OLDER_VERSION_SERIALIZED_CHECKPOINT);
            Assertions.assertThat((Iterable)olderVersionDeserializedCheckpoint).containsExactlyInAnyOrder((Object[])new ShardCheckpoint[]{shardCheckpoint});
        }
        catch (ClassNotFoundException e) {
            String errorMessage = String.format("KinesisReaderCheckpoint may have changed. Consider update OLDER_VERSION_SERIALIZED_CHECKPOINT: \"%s\"", serializedCheckpoint);
            throw new RuntimeException(errorMessage, e);
        }
    }

    private void verifySplitInto(KinesisReaderCheckpoint checkpoint, int size) {
        List split = checkpoint.splitInto(size);
        Assertions.assertThat((Iterable)Iterables.concat((Iterable)split)).containsOnly((Object[])new ShardCheckpoint[]{this.a, this.b, this.c});
        Assertions.assertThat((List)split).hasSize(Math.min(size, 3));
    }

    private static String serializeObjectToString(Serializable o) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(outputStream);
        oos.writeObject(o);
        oos.close();
        return Base64.getEncoder().encodeToString(outputStream.toByteArray());
    }

    private static Object deSerializeObjectFromString(String s) throws IOException, ClassNotFoundException {
        byte[] data = Base64.getDecoder().decode(s);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        Object o = ois.readObject();
        ois.close();
        return o;
    }
}

