/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.util.Map;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisIOOptions;
import org.apache.beam.sdk.io.aws2.kinesis.TestHelpers;
import org.apache.beam.sdk.io.aws2.options.SerializationTestUtil;
import org.apache.beam.sdk.options.PipelineOptions;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class KinesisIOOptionsTest {
    private KinesisIOOptions serializeDeserialize(KinesisIOOptions opts) {
        return (KinesisIOOptions)((PipelineOptions)SerializationTestUtil.serializeDeserialize(PipelineOptions.class, opts)).as(KinesisIOOptions.class);
    }

    @Test
    public void testSerializeDeserializeDefaults() {
        KinesisIOOptions options = TestHelpers.createIOOptions(new String[0]);
        KinesisIOOptions copy = this.serializeDeserialize(options);
        Map consumerMapping = options.getKinesisIOConsumerArns();
        Map copyMapping = copy.getKinesisIOConsumerArns();
        Assertions.assertThat((int)copyMapping.size()).isEqualTo(0);
        Assertions.assertThat((Map)copyMapping).isEqualTo((Object)consumerMapping);
    }

    @Test
    public void testConsumerMapping() {
        KinesisIOOptions options = TestHelpers.createIOOptions("--kinesisIOConsumerArns={\"stream-01\": \"arn-01\", \"stream-02\": \"arn-02\"}");
        KinesisIOOptions copy = this.serializeDeserialize(options);
        Map consumerMapping = copy.getKinesisIOConsumerArns();
        Assertions.assertThat((String)((String)consumerMapping.get("stream-01"))).isEqualTo((Object)"arn-01");
        Assertions.assertThat((String)((String)consumerMapping.get("stream-02"))).isEqualTo((Object)"arn-02");
        Assertions.assertThat((String)((String)consumerMapping.get("other"))).isNull();
    }

    @Test
    public void testNullConsumerArn() {
        KinesisIOOptions options = TestHelpers.createIOOptions("--kinesisIOConsumerArns={\"stream-01\": null}");
        KinesisIOOptions copy = this.serializeDeserialize(options);
        Map consumerMapping = copy.getKinesisIOConsumerArns();
        Assertions.assertThat((boolean)consumerMapping.containsKey("stream-01")).isTrue();
        Assertions.assertThat((String)((String)consumerMapping.get("stream-01"))).isNull();
        Assertions.assertThat((boolean)consumerMapping.containsKey("other")).isFalse();
        Assertions.assertThat((String)((String)consumerMapping.get("other"))).isNull();
    }
}

