/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.dynamodb.testing;

import java.io.Serializable;
import java.util.Map;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.io.aws2.ITEnvironment;
import org.apache.beam.sdk.io.aws2.dynamodb.DynamoDBIO;
import org.apache.beam.sdk.io.common.HashingFn;
import org.apache.beam.sdk.io.common.TestRow;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExternalResource;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.testcontainers.containers.localstack.LocalStackContainer;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@RunWith(value=JUnit4.class)
public class DynamoDBIOIT {
    private static final String COL_ID = "id";
    private static final String COL_NAME = "name";
    @ClassRule
    public static ITEnvironment<ITOptions> env = new ITEnvironment<ITOptions>(LocalStackContainer.Service.DYNAMODB, ITOptions.class, "DYNAMODB_ERROR_PROBABILITY=0.1");
    @Rule
    public TestPipeline pipelineWrite = env.createTestPipeline();
    @Rule
    public TestPipeline pipelineRead = env.createTestPipeline();
    @Rule
    public ExternalResource dbTable = CreateDbTable.optionally(env.options());

    @Test
    public void testWriteThenRead() {
        this.runWrite();
        this.runRead();
    }

    private void runWrite() {
        int rows = env.options().getNumberOfRows();
        ((PCollection)((PCollection)this.pipelineWrite.apply("Generate Sequence", (PTransform)GenerateSequence.from((long)0L).to((long)rows))).apply("Prepare TestRows", (PTransform)ParDo.of((DoFn)new TestRow.DeterministicallyConstructTestRowFn()))).apply("Write to DynamoDB", (PTransform)DynamoDBIO.write().withWriteRequestMapperFn((SerializableFunction & Serializable)row -> DynamoDBIOIT.buildWriteRequest(row)));
        this.pipelineWrite.run().waitUntilFinish();
    }

    private void runRead() {
        int rows = env.options().getNumberOfRows();
        PCollection records = (PCollection)((PCollection)this.pipelineRead.apply("Read from DynamoDB", (PTransform)DynamoDBIO.read().withScanRequestFn((SerializableFunction & Serializable)in -> DynamoDBIOIT.buildScanRequest()).items())).apply("Flatten result", (PTransform)Flatten.iterables());
        PAssert.thatSingleton((PCollection)((PCollection)records.apply("Count All", Count.globally()))).isEqualTo((Object)rows);
        PCollection consolidatedHashcode = (PCollection)((PCollection)records.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)record -> ((AttributeValue)record.get(COL_NAME)).s()))).apply("Hash records", (PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new HashingFn()).withoutDefaults());
        PAssert.that((PCollection)consolidatedHashcode).containsInAnyOrder((Object[])new String[]{TestRow.getExpectedHashForRowCount((int)rows)});
        this.pipelineRead.run().waitUntilFinish();
    }

    private static ScanRequest buildScanRequest() {
        return (ScanRequest)ScanRequest.builder().tableName(env.options().getDynamoDBTable()).totalSegments(env.options().getDynamoDBSegments()).build();
    }

    private static KV<String, WriteRequest> buildWriteRequest(TestRow row) {
        AttributeValue id = (AttributeValue)AttributeValue.builder().n(row.id().toString()).build();
        AttributeValue name = (AttributeValue)AttributeValue.builder().s(row.name()).build();
        PutRequest req = (PutRequest)PutRequest.builder().item((Map)ImmutableMap.of((Object)COL_ID, (Object)id, (Object)COL_NAME, (Object)name)).build();
        return KV.of((Object)env.options().getDynamoDBTable(), (Object)((WriteRequest)WriteRequest.builder().putRequest(req).build()));
    }

    static class CreateDbTable
    extends ExternalResource {
        private final String name = env.options().getDynamoDBTable();
        private final DynamoDbClient client = (DynamoDbClient)env.buildClient(DynamoDbClient.builder());

        CreateDbTable() {
        }

        static ExternalResource optionally(ITOptions opts) {
            boolean create = opts.getCreateTable() != false || opts.getUseLocalstack() != false;
            return create ? new CreateDbTable() : new ExternalResource(){};
        }

        protected void before() throws Throwable {
            CreateTableRequest request = (CreateTableRequest)CreateTableRequest.builder().tableName(this.name).attributeDefinitions(new AttributeDefinition[]{this.attribute(DynamoDBIOIT.COL_ID, ScalarAttributeType.N), this.attribute(DynamoDBIOIT.COL_NAME, ScalarAttributeType.S)}).keySchema(new KeySchemaElement[]{this.keyElement(DynamoDBIOIT.COL_ID, KeyType.HASH), this.keyElement(DynamoDBIOIT.COL_NAME, KeyType.RANGE)}).provisionedThroughput((ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(Long.valueOf(1000L)).writeCapacityUnits(Long.valueOf(1000L)).build()).build();
            TableStatus status = this.client.createTable(request).tableDescription().tableStatus();
            int attempts = 10;
            for (int i = 0; i <= attempts; ++i) {
                if (status == TableStatus.ACTIVE) {
                    return;
                }
                Thread.sleep(1000L);
                status = this.client.describeTable(b -> {
                    DescribeTableRequest cfr_ignored_0 = (DescribeTableRequest)b.tableName(this.name).build();
                }).table().tableStatus();
            }
            throw new RuntimeException("Unable to initialize table");
        }

        protected void after() {
            this.client.deleteTable(b -> {
                DeleteTableRequest cfr_ignored_0 = (DeleteTableRequest)b.tableName(this.name).build();
            });
            this.client.close();
        }

        private AttributeDefinition attribute(String name, ScalarAttributeType type) {
            return (AttributeDefinition)AttributeDefinition.builder().attributeName(name).attributeType(type).build();
        }

        private KeySchemaElement keyElement(String name, KeyType type) {
            return (KeySchemaElement)KeySchemaElement.builder().attributeName(name).keyType(type).build();
        }
    }

    public static interface ITOptions
    extends ITEnvironment.ITOptions {
        @Description(value="DynamoDB table name")
        @Default.String(value="beam-dynamodbio-it")
        public String getDynamoDBTable();

        public void setDynamoDBTable(String var1);

        @Description(value="DynamoDB total segments")
        @Default.Integer(value=2)
        public Integer getDynamoDBSegments();

        public void setDynamoDBSegments(Integer var1);

        @Description(value="Create DynamoDB table. Enabled when using localstack")
        @Default.Boolean(value=false)
        public Boolean getCreateTable();

        public void setCreateTable(Boolean var1);
    }
}

