/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.dynamodb;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.io.aws2.MockClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.dynamodb.DynamoDBIO;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

@RunWith(value=MockitoJUnitRunner.class)
public class DynamoDBIOReadTest {
    private static final String tableName = "Test";
    @Rule
    public final TestPipeline pipeline = TestPipeline.create();
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    @Mock
    public DynamoDbClient client;

    @Before
    public void configureClientBuilderFactory() {
        MockClientBuilderFactory.set(this.pipeline, DynamoDbClientBuilder.class, this.client);
    }

    private DynamoDBIO.Read<List<Map<String, AttributeValue>>> dynamoDbRead(Integer segments) {
        return DynamoDBIO.read().withScanRequestFn((SerializableFunction & Serializable)in -> (ScanRequest)ScanRequest.builder().tableName(tableName).totalSegments(segments).build()).items();
    }

    @Test
    public void testReadOneSegment() {
        MockData mockData = new MockData(IntStream.range(0, 10));
        mockData.mockScan(10, this.client);
        DynamoDBIO.Read<List<Map<String, AttributeValue>>> read = this.dynamoDbRead(1);
        PCollection actual = (PCollection)this.pipeline.apply(read);
        PAssert.that((PCollection)((PCollection)actual.apply(Count.globally()))).containsInAnyOrder((Object[])new Long[]{1L});
        PAssert.that((PCollection)actual).containsInAnyOrder((Object[])new List[]{mockData.getAllItems()});
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testReadWithCustomLimit() {
        int requestedLimit = 100;
        MockData mockData = new MockData(IntStream.range(0, 10));
        mockData.mockScan(100, this.client);
        this.pipeline.apply((PTransform)this.dynamoDbRead(1).withScanRequestFn((SerializableFunction & Serializable)in -> (ScanRequest)ScanRequest.builder().tableName(tableName).totalSegments(Integer.valueOf(1)).limit(Integer.valueOf(100)).build()));
        this.pipeline.run().waitUntilFinish();
        ((DynamoDbClient)Mockito.verify((Object)this.client)).scan((ScanRequest)ArgumentMatchers.argThat(req -> 100 == req.limit()));
    }

    @Test
    public void testReadThreeSegments() {
        MockData mockData = new MockData(IntStream.range(0, 10), IntStream.range(10, 20), IntStream.range(20, 30));
        mockData.mockScan(10, this.client);
        DynamoDBIO.Read<List<Map<String, AttributeValue>>> read = this.dynamoDbRead(3);
        PCollection actual = (PCollection)this.pipeline.apply(read);
        PAssert.that((PCollection)((PCollection)actual.apply(Count.globally()))).containsInAnyOrder((Object[])new Long[]{3L});
        PAssert.that((PCollection)((PCollection)actual.apply((PTransform)Flatten.iterables()))).containsInAnyOrder(mockData.getAllItems());
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testReadWithStartKey() {
        MockData mockData = new MockData(IntStream.range(0, 10), IntStream.range(20, 32));
        mockData.mockScan(5, this.client);
        PCollection actual = (PCollection)this.pipeline.apply(this.dynamoDbRead(2));
        PAssert.that((PCollection)((PCollection)actual.apply(Count.globally()))).containsInAnyOrder((Object[])new Long[]{5L});
        PAssert.that((PCollection)((PCollection)actual.apply((PTransform)Flatten.iterables()))).containsInAnyOrder(mockData.getAllItems());
        this.pipeline.run().waitUntilFinish();
    }

    @Test
    public void testReadMissingScanRequestFn() {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("withScanRequestFn() is required");
        this.pipeline.apply((PTransform)this.dynamoDbRead(null).withScanRequestFn(null));
    }

    @Test
    public void testReadMissingTotalSegments() {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("TotalSegments is required with withScanRequestFn() and greater zero");
        this.pipeline.apply(this.dynamoDbRead(null));
    }

    @Test
    public void testReadInvalidTotalSegments() {
        this.pipeline.enableAbandonedNodeEnforcement(false);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("TotalSegments is required with withScanRequestFn() and greater zero");
        this.pipeline.apply(this.dynamoDbRead(0));
    }

    private static Map<String, AttributeValue> item(int id) {
        return ImmutableMap.of((Object)"rangeKey", (Object)((AttributeValue)AttributeValue.builder().n(String.valueOf(id)).build()), (Object)"hashKey", (Object)((AttributeValue)AttributeValue.builder().s(String.valueOf(id)).build()));
    }

    private static class MockData {
        private final List<List<Integer>> data;

        MockData(IntStream ... segments) {
            this.data = Arrays.stream(segments).map(ids -> Lists.newArrayList((Iterator)ids.iterator())).collect(Collectors.toList());
        }

        List<Map<String, AttributeValue>> getAllItems() {
            return this.data.stream().flatMap(ids -> ids.stream()).map(id -> DynamoDBIOReadTest.item(id)).collect(Collectors.toList());
        }

        void mockScan(int sizeLimit, DynamoDbClient mock) {
            for (int segment = 0; segment < this.data.size(); ++segment) {
                List<Integer> ids = this.data.get(segment);
                List items = null;
                for (int start = 0; start < ids.size(); start += sizeLimit) {
                    ImmutableMap startKey = items != null ? (Map)Iterables.getLast(items) : ImmutableMap.of();
                    items = Lists.transform(ids.subList(start, Math.min(ids.size(), start + sizeLimit)), id -> DynamoDBIOReadTest.item(id));
                    ImmutableMap lastKey = start + sizeLimit < ids.size() ? (Map)Iterables.getLast((Iterable)items) : ImmutableMap.of();
                    Mockito.when((Object)mock.scan((ScanRequest)ArgumentMatchers.argThat(this.matchesScanRequest(segment, (Map<String, AttributeValue>)startKey)))).thenReturn((Object)((ScanResponse)ScanResponse.builder().items((Collection)items).lastEvaluatedKey((Map)lastKey).build()));
                }
            }
        }

        ArgumentMatcher<ScanRequest> matchesScanRequest(Integer segment, Map<String, AttributeValue> startKey) {
            return req -> req != null && segment.equals(req.segment()) && startKey.equals(req.exclusiveStartKey());
        }
    }
}

