/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.dynamodb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.beam.sdk.io.aws2.dynamodb.AttributeValueCoder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.Test;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class AttributeValueCoderTest {
    @Test
    public void shouldPassForStringType() throws IOException {
        AttributeValue expected = (AttributeValue)AttributeValue.builder().s("test").build();
        AttributeValueCoder coder = AttributeValueCoder.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        AttributeValue actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldPassForNumberType() throws IOException {
        AttributeValue expected = (AttributeValue)AttributeValue.builder().n("123").build();
        AttributeValueCoder coder = AttributeValueCoder.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        AttributeValue actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldPassForBooleanType() throws IOException {
        AttributeValue expected = (AttributeValue)AttributeValue.builder().bool(Boolean.valueOf(false)).build();
        AttributeValueCoder coder = AttributeValueCoder.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        AttributeValue actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldPassForByteArray() throws IOException {
        AttributeValue expected = (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])"hello".getBytes(StandardCharsets.UTF_8))).build();
        AttributeValueCoder coder = AttributeValueCoder.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        AttributeValue actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldPassForListOfString() throws IOException {
        AttributeValue expected = (AttributeValue)AttributeValue.builder().ss((Collection)ImmutableList.of((Object)"foo", (Object)"bar")).build();
        AttributeValueCoder coder = AttributeValueCoder.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        AttributeValue actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldPassForOneListOfNumber() throws IOException {
        AttributeValue expected = (AttributeValue)AttributeValue.builder().ns((Collection)ImmutableList.of((Object)"123", (Object)"456")).build();
        AttributeValueCoder coder = AttributeValueCoder.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        AttributeValue actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldPassForOneListOfByteArray() throws IOException {
        AttributeValue expected = (AttributeValue)AttributeValue.builder().bs((Collection)ImmutableList.of((Object)SdkBytes.fromByteArray((byte[])"mylistbyte1".getBytes(StandardCharsets.UTF_8)), (Object)SdkBytes.fromByteArray((byte[])"mylistbyte2".getBytes(StandardCharsets.UTF_8)))).build();
        AttributeValueCoder coder = AttributeValueCoder.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        AttributeValue actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldPassForListType() throws IOException {
        ArrayList<AttributeValue> listAttr = new ArrayList<AttributeValue>();
        listAttr.add((AttributeValue)AttributeValue.builder().s("innerMapValue1").build());
        listAttr.add((AttributeValue)AttributeValue.builder().n("8976234").build());
        AttributeValue expected = (AttributeValue)AttributeValue.builder().l(listAttr).build();
        AttributeValueCoder coder = AttributeValueCoder.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        AttributeValue actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldPassForMapType() throws IOException {
        HashMap<String, AttributeValue> attrMap = new HashMap<String, AttributeValue>();
        attrMap.put("innerMapAttr1", (AttributeValue)AttributeValue.builder().s("innerMapValue1").build());
        attrMap.put("innerMapAttr2", (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])"8976234".getBytes(StandardCharsets.UTF_8))).build());
        AttributeValue expected = (AttributeValue)AttributeValue.builder().m(attrMap).build();
        AttributeValueCoder coder = AttributeValueCoder.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        AttributeValue actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldPassForNullType() throws IOException {
        AttributeValue expected = (AttributeValue)AttributeValue.builder().nul(Boolean.valueOf(true)).build();
        AttributeValueCoder coder = AttributeValueCoder.of();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        coder.encode(expected, (OutputStream)output);
        ByteArrayInputStream in = new ByteArrayInputStream(output.toByteArray());
        AttributeValue actual = coder.decode((InputStream)in);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

