/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.common;

import org.apache.beam.sdk.io.aws2.common.RetryConfiguration;
import org.apache.beam.sdk.io.aws2.options.SerializationTestUtil;
import org.assertj.core.api.Assertions;
import org.joda.time.Duration;
import org.junit.Test;

public class RetryConfigurationTest {
    @Test
    public void verifyNumRetriesNotNegative() {
        Assertions.assertThatThrownBy(() -> RetryConfiguration.builder().numRetries(-1).build()).hasMessage("numRetries must not be negative");
    }

    @Test
    public void verifyBaseBackoffLargerZero() {
        Assertions.assertThatThrownBy(() -> RetryConfiguration.builder().numRetries(1).baseBackoff(Duration.ZERO).build()).hasMessage("baseBackoff must be greater than 0");
    }

    @Test
    public void verifyThrottledBaseBackoffLargerZero() {
        Assertions.assertThatThrownBy(() -> RetryConfiguration.builder().numRetries(1).throttledBaseBackoff(Duration.ZERO).build()).hasMessage("throttledBaseBackoff must be greater than 0");
    }

    @Test
    public void verifyMaxBackoffLargerZero() {
        Assertions.assertThatThrownBy(() -> RetryConfiguration.builder().numRetries(1).maxBackoff(Duration.ZERO).build()).hasMessage("maxBackoff must be greater than 0");
    }

    @Test
    public void testJsonSerialization() {
        RetryConfiguration config = RetryConfiguration.builder().numRetries(10).build();
        Assertions.assertThat((Object)this.jsonSerializeDeserialize(config)).isEqualTo((Object)config);
        config = config.toBuilder().maxBackoff(Duration.millis((long)1000L)).build();
        Assertions.assertThat((Object)this.jsonSerializeDeserialize(config)).isEqualTo((Object)config);
        config = config.toBuilder().baseBackoff(Duration.millis((long)200L)).build();
        Assertions.assertThat((Object)this.jsonSerializeDeserialize(config)).isEqualTo((Object)config);
        config = config.toBuilder().throttledBaseBackoff(Duration.millis((long)100L)).build();
        Assertions.assertThat((Object)this.jsonSerializeDeserialize(config)).isEqualTo((Object)config);
    }

    private RetryConfiguration jsonSerializeDeserialize(RetryConfiguration obj) {
        return SerializationTestUtil.serializeDeserialize(RetryConfiguration.class, obj);
    }
}

