/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.common;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.beam.sdk.io.aws2.common.ObjectPool;
import org.apache.beam.sdk.testing.ExpectedLogs;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ObjectPoolTest {
    Function<String, AutoCloseable> provider = (Function)Mockito.spy((Object)new Provider());
    ObjectPool<String, AutoCloseable> pool = new ObjectPool(this.provider, obj -> obj.close());
    @Rule
    public ExpectedLogs logs = ExpectedLogs.none(ObjectPool.class);

    @Test
    public void concurrentRetainRelease() throws Exception {
        List futures = Stream.generate(() -> new ResourceTask()).limit(100000L).map(ForkJoinPool.commonPool()::submit).collect(Collectors.toList());
        futures.stream().forEach(ForkJoinTask::join);
        Assertions.assertThat((boolean)futures.stream().allMatch(ForkJoinTask::isCompletedNormally)).isTrue();
        for (ForkJoinTask future : futures) {
            ((AutoCloseable)Mockito.verify((Object)((AutoCloseable)future.get()))).close();
        }
    }

    @Test
    public void shareClientsOfSameConfiguration() {
        String config1 = "config1";
        String config2 = "config2";
        Assertions.assertThat((Object)((AutoCloseable)this.pool.retain((Object)config1))).isSameAs(this.pool.retain((Object)config1));
        Assertions.assertThat((Object)((AutoCloseable)this.pool.retain((Object)config1))).isNotSameAs(this.pool.retain((Object)config2));
        ((Function)Mockito.verify(this.provider, (VerificationMode)Mockito.times((int)2))).apply(ArgumentMatchers.anyString());
        ((Function)Mockito.verify(this.provider, (VerificationMode)Mockito.times((int)1))).apply(config1);
        ((Function)Mockito.verify(this.provider, (VerificationMode)Mockito.times((int)1))).apply(config2);
    }

    @Test
    public void closeClientsOnceReleased() throws Exception {
        int i;
        String config = "config";
        int sharedInstances = 10;
        AutoCloseable client = null;
        for (i = 0; i < sharedInstances; ++i) {
            client = (AutoCloseable)this.pool.retain((Object)config);
        }
        for (i = 0; i < sharedInstances - 1; ++i) {
            this.pool.release((Object)client);
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{client});
        this.pool.release((Object)client);
        ((AutoCloseable)Mockito.verify((Object)client)).close();
        this.pool.release((Object)client);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{client});
    }

    @Test
    public void closeClientsOnceReleasedByKey() throws Exception {
        int i;
        String config = "config";
        int sharedInstances = 10;
        AutoCloseable client = null;
        for (i = 0; i < sharedInstances; ++i) {
            client = (AutoCloseable)this.pool.retain((Object)config);
        }
        for (i = 0; i < sharedInstances - 1; ++i) {
            this.pool.releaseByKey((Object)config);
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{client});
        this.pool.releaseByKey((Object)config);
        ((AutoCloseable)Mockito.verify((Object)client)).close();
        this.pool.releaseByKey((Object)config);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{client});
    }

    @Test
    public void recreateClientOnceReleased() throws Exception {
        String config = "config";
        AutoCloseable client1 = (AutoCloseable)this.pool.retain((Object)config);
        this.pool.release((Object)client1);
        ((AutoCloseable)Mockito.verify((Object)client1)).close();
        AutoCloseable client2 = (AutoCloseable)this.pool.retain((Object)config);
        Mockito.verifyNoInteractions((Object[])new Object[]{client2});
        ((Function)Mockito.verify(this.provider, (VerificationMode)Mockito.times((int)2))).apply(config);
        Assertions.assertThat((Object)client1).isNotSameAs((Object)client2);
    }

    @Test
    public void releaseWithError() throws Exception {
        Exception onClose = new Exception("error on close");
        AutoCloseable client = (AutoCloseable)this.pool.retain((Object)"config");
        ((AutoCloseable)Mockito.doThrow((Throwable[])new Throwable[]{onClose}).when((Object)client)).close();
        this.pool.release((Object)client);
        ((AutoCloseable)Mockito.verify((Object)client)).close();
        this.logs.verifyWarn("Exception destroying pooled object.", (Throwable)onClose);
    }

    static class Provider
    implements Function<String, AutoCloseable> {
        Provider() {
        }

        @Override
        public AutoCloseable apply(String configName) {
            return (AutoCloseable)Mockito.mock(AutoCloseable.class, (String)configName);
        }
    }

    class ResourceTask
    implements Callable<AutoCloseable> {
        ResourceTask() {
        }

        @Override
        public AutoCloseable call() {
            AutoCloseable client = (AutoCloseable)ObjectPoolTest.this.pool.retain((Object)"config");
            ObjectPoolTest.this.pool.retain((Object)"config");
            ObjectPoolTest.this.pool.release((Object)client);
            Mockito.verifyNoInteractions((Object[])new Object[]{client});
            ObjectPoolTest.this.pool.release((Object)client);
            return client;
        }
    }
}

