/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.common;

import java.io.Serializable;
import java.net.URI;
import org.apache.beam.sdk.io.aws2.common.ClientConfiguration;
import org.apache.beam.sdk.io.aws2.options.SerializationTestUtil;
import org.apache.beam.sdk.util.SerializableUtils;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class ClientConfigurationTest {
    @Test
    public void testJavaSerialization() {
        StaticCredentialsProvider credentials = StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)"key", (String)"secret"));
        ClientConfiguration config = ClientConfiguration.builder().credentialsProvider((AwsCredentialsProvider)credentials).region(Region.US_WEST_1).endpoint(URI.create("https://localhost")).retry(b -> b.numRetries(3)).build();
        byte[] serializedBytes = SerializableUtils.serializeToByteArray((Serializable)config);
        ClientConfiguration deserializedConfig = (ClientConfiguration)SerializableUtils.deserializeFromByteArray((byte[])serializedBytes, (String)"ClientConfiguration");
        Assertions.assertThat((Object)deserializedConfig).isEqualTo((Object)config);
    }

    @Test
    public void testJsonSerialization() {
        ClientConfiguration config = ClientConfiguration.builder().build();
        Assertions.assertThat((Object)this.jsonSerializeDeserialize(config)).isEqualTo((Object)config);
        config = config.toBuilder().region(Region.US_WEST_1).build();
        Assertions.assertThat((Object)this.jsonSerializeDeserialize(config)).isEqualTo((Object)config);
        config = config.toBuilder().credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create()).build();
        Assertions.assertThat((Object)this.jsonSerializeDeserialize(config)).isEqualTo((Object)config);
        AwsBasicCredentials credentials = AwsBasicCredentials.create((String)"key", (String)"secret");
        StaticCredentialsProvider credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)credentials);
        config = config.toBuilder().credentialsProvider((AwsCredentialsProvider)credentialsProvider).build();
        Assertions.assertThat((Object)this.jsonSerializeDeserialize(config)).isEqualTo((Object)config);
        config = config.toBuilder().endpoint(URI.create("https://localhost:8080")).build();
        Assertions.assertThat((Object)this.jsonSerializeDeserialize(config)).isEqualTo((Object)config);
        config = config.toBuilder().retry(r -> r.numRetries(10)).build();
        Assertions.assertThat((Object)this.jsonSerializeDeserialize(config)).isEqualTo((Object)config);
    }

    private ClientConfiguration jsonSerializeDeserialize(ClientConfiguration obj) {
        return SerializationTestUtil.serializeDeserialize(ClientConfiguration.class, obj);
    }
}

