/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.common;

import java.net.URI;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.beam.sdk.io.aws2.common.ClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.common.ClientConfiguration;
import org.apache.beam.sdk.io.aws2.common.HttpClientConfiguration;
import org.apache.beam.sdk.io.aws2.options.AwsOptions;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.client.builder.SdkAsyncClientBuilder;
import software.amazon.awssdk.core.client.builder.SdkSyncClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.regions.Region;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class ClientBuilderFactoryTest {
    @Mock
    AwsBuilder builder;
    @Mock
    AwsOptions awsOptions;

    @Before
    public void prepareOptions() {
        Mockito.when((Object)this.awsOptions.getClientBuilderFactory()).thenReturn(TestClientBuilderFactory.class);
        Mockito.when((Object)this.awsOptions.getAwsRegion()).thenReturn((Object)Region.EU_WEST_2);
        Mockito.when((Object)this.awsOptions.getAwsCredentialsProvider()).thenReturn((Object)((AwsCredentialsProvider)Mockito.mock(AwsCredentialsProvider.class)));
    }

    @Test
    public void testGetFactoryInstance() {
        Assertions.assertThat((Object)ClientBuilderFactory.getFactory((AwsOptions)this.awsOptions)).isInstanceOf(TestClientBuilderFactory.class);
        Mockito.when((Object)this.awsOptions.getClientBuilderFactory()).thenReturn(ClientBuilderFactory.DefaultClientBuilder.class);
        Assertions.assertThat((Object)ClientBuilderFactory.getFactory((AwsOptions)this.awsOptions)).isSameAs((Object)ClientBuilderFactory.defaultFactory());
    }

    @Test
    public void testValidate() {
        AwsCredentialsProvider mock = (AwsCredentialsProvider)Mockito.mock(AwsCredentialsProvider.class);
        Mockito.when((Object)this.awsOptions.getAwsCredentialsProvider()).thenReturn((Object)mock);
        Mockito.when((Object)mock.resolveCredentials()).thenReturn((Object)((AwsCredentials)Mockito.mock(AwsCredentials.class)));
        ClientBuilderFactory.validate((AwsOptions)this.awsOptions, (ClientConfiguration)ClientConfiguration.builder().build());
    }

    @Test
    public void testCheckConfigurationUsingOptions() {
        ClientConfiguration config = ClientConfiguration.builder().build();
        Mockito.when((Object)this.awsOptions.getAwsRegion()).thenReturn(null);
        Assertions.assertThatThrownBy(() -> ClientBuilderFactory.defaultFactory().checkConfiguration(config, this.awsOptions)).hasMessage("No AWS region available");
        Mockito.when((Object)this.awsOptions.getAwsRegion()).thenReturn((Object)Region.EU_WEST_2);
        Mockito.when((Object)this.awsOptions.getAwsCredentialsProvider()).thenReturn(null);
        Assertions.assertThatThrownBy(() -> ClientBuilderFactory.defaultFactory().checkConfiguration(config, this.awsOptions)).hasMessage("No AWS credentials provider available");
        AwsCredentialsProvider mock = (AwsCredentialsProvider)Mockito.mock(AwsCredentialsProvider.class);
        Mockito.when((Object)this.awsOptions.getAwsCredentialsProvider()).thenReturn((Object)mock);
        Mockito.when((Object)mock.resolveCredentials()).thenReturn((Object)((AwsCredentials)Mockito.mock(AwsCredentials.class)));
        ClientBuilderFactory.defaultFactory().checkConfiguration(config, this.awsOptions);
        Mockito.when((Object)mock.resolveCredentials()).thenThrow(new Throwable[]{new RuntimeException("Error resolving credentials")});
        Assertions.assertThatThrownBy(() -> ClientBuilderFactory.defaultFactory().checkConfiguration(config, this.awsOptions)).hasMessage("Error resolving credentials");
    }

    @Test
    public void testCheckConfigurationUsingConfig() {
        Mockito.when((Object)this.awsOptions.getAwsRegion()).thenReturn(null);
        Mockito.when((Object)this.awsOptions.getAwsCredentialsProvider()).thenReturn(null);
        ClientConfiguration noRegion = ClientConfiguration.builder().build();
        Assertions.assertThatThrownBy(() -> ClientBuilderFactory.defaultFactory().checkConfiguration(noRegion, this.awsOptions)).hasMessage("No AWS region available");
        ClientConfiguration noCredentials = ClientConfiguration.builder().region(Region.US_WEST_1).build();
        Assertions.assertThatThrownBy(() -> ClientBuilderFactory.defaultFactory().checkConfiguration(noCredentials, this.awsOptions)).hasMessage("No AWS credentials provider available");
        AwsBasicCredentials credentials = AwsBasicCredentials.create((String)"key", (String)"secret");
        ClientConfiguration valid = ClientConfiguration.builder().region(Region.US_WEST_1).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentials)).build();
        ClientBuilderFactory.defaultFactory().checkConfiguration(valid, this.awsOptions);
        ClientBuilderFactory.defaultFactory().checkConfiguration(valid, null);
    }

    @Test
    public void testBaseSettingsFromClientConfig() {
        ClientConfiguration config = ClientConfiguration.builder().region(Region.US_WEST_1).credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create()).build();
        ClientBuilderFactory.getFactory((AwsOptions)this.awsOptions).create((AwsClientBuilder)this.builder, config, null);
        ((AwsBuilder)Mockito.verify((Object)this.builder)).region(config.region());
        ((AwsBuilder)Mockito.verify((Object)this.builder)).credentialsProvider(config.credentialsProvider());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.builder});
        Mockito.clearInvocations((Object[])new AwsBuilder[]{this.builder});
        ClientBuilderFactory.getFactory((AwsOptions)this.awsOptions).create((AwsClientBuilder)this.builder, config, this.awsOptions);
        ((AwsBuilder)Mockito.verify((Object)this.builder)).region(config.region());
        ((AwsBuilder)Mockito.verify((Object)this.builder)).credentialsProvider(config.credentialsProvider());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.builder});
    }

    @Test
    public void testBuildClientFromOptions() {
        ClientConfiguration config = ClientConfiguration.builder().build();
        ClientBuilderFactory.buildClient((AwsOptions)this.awsOptions, (AwsClientBuilder)this.builder, (ClientConfiguration)config);
        ((AwsBuilder)Mockito.verify((Object)this.builder)).region(this.awsOptions.getAwsRegion());
        ((AwsBuilder)Mockito.verify((Object)this.builder)).credentialsProvider(this.awsOptions.getAwsCredentialsProvider());
        ((AwsBuilder)Mockito.verify((Object)this.builder)).build();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.builder});
    }

    @Test
    public void testBaseSettingsFromOptions() {
        ClientConfiguration config = ClientConfiguration.builder().build();
        ClientBuilderFactory.getFactory((AwsOptions)this.awsOptions).create((AwsClientBuilder)this.builder, config, this.awsOptions);
        ((AwsBuilder)Mockito.verify((Object)this.builder)).region(this.awsOptions.getAwsRegion());
        ((AwsBuilder)Mockito.verify((Object)this.builder)).credentialsProvider(this.awsOptions.getAwsCredentialsProvider());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.builder});
    }

    @Test
    public void testEndpointFromClientConfig() {
        ClientConfiguration config = ClientConfiguration.builder().endpoint(URI.create("https://localhost")).build();
        ClientBuilderFactory.getFactory((AwsOptions)this.awsOptions).create((AwsClientBuilder)this.builder, config, this.awsOptions);
        ((AwsBuilder)Mockito.verify((Object)this.builder)).endpointOverride(config.endpoint());
        ((AwsBuilder)Mockito.verify((Object)this.builder)).region(this.awsOptions.getAwsRegion());
        ((AwsBuilder)Mockito.verify((Object)this.builder)).credentialsProvider(this.awsOptions.getAwsCredentialsProvider());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.builder});
    }

    @Test
    public void testEndpointFromOptions() {
        ClientConfiguration config = ClientConfiguration.builder().build();
        Mockito.when((Object)this.awsOptions.getEndpoint()).thenReturn((Object)URI.create("https://options"));
        ClientBuilderFactory.getFactory((AwsOptions)this.awsOptions).create((AwsClientBuilder)this.builder, config, this.awsOptions);
        ((AwsBuilder)Mockito.verify((Object)this.builder)).endpointOverride(this.awsOptions.getEndpoint());
        ((AwsBuilder)Mockito.verify((Object)this.builder)).region(this.awsOptions.getAwsRegion());
        ((AwsBuilder)Mockito.verify((Object)this.builder)).credentialsProvider(this.awsOptions.getAwsCredentialsProvider());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.builder});
    }

    @Test
    public void testRetryConfiguration() {
        ClientConfiguration config = ClientConfiguration.builder().retry(b -> b.numRetries(3)).build();
        ClientBuilderFactory.getFactory((AwsOptions)this.awsOptions).create((AwsClientBuilder)this.builder, config, this.awsOptions);
        ArgumentCaptor overrideConfig = ArgumentCaptor.forClass(ClientOverrideConfiguration.class);
        ((AwsBuilder)Mockito.verify((Object)this.builder)).overrideConfiguration((ClientOverrideConfiguration)overrideConfig.capture());
        ((AwsBuilder)Mockito.verify((Object)this.builder)).region(this.awsOptions.getAwsRegion());
        ((AwsBuilder)Mockito.verify((Object)this.builder)).credentialsProvider(this.awsOptions.getAwsCredentialsProvider());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.builder});
        Assertions.assertThat((Optional)((ClientOverrideConfiguration)overrideConfig.getValue()).retryPolicy()).contains((Object)config.retry().toClientRetryPolicy());
    }

    @Test
    public void testSyncProxyConfiguration() {
        ProxyConfiguration proxy = (ProxyConfiguration)ProxyConfiguration.builder().endpoint(URI.create("http://localhost:7777")).username("user").password("secret").build();
        this.builder = (AwsBuilder)Mockito.mock(AwsSyncBuilder.class);
        Mockito.when((Object)this.awsOptions.getProxyConfiguration()).thenReturn((Object)proxy);
        ClientBuilderFactory.getFactory((AwsOptions)this.awsOptions).create((AwsClientBuilder)this.builder, this.awsOptions);
        ArgumentCaptor httpClientBuilder = ArgumentCaptor.forClass(ApacheHttpClient.Builder.class);
        ((AwsSyncBuilder)Mockito.verify((Object)((AwsSyncBuilder)this.builder))).httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder.capture());
        ((ApacheHttpClient.Builder)Mockito.verify((Object)((ApacheHttpClient.Builder)httpClientBuilder.getValue()))).proxyConfiguration(proxy);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{httpClientBuilder.getValue()});
    }

    @Test
    public void testAsyncProxyConfiguration() {
        ProxyConfiguration proxy = (ProxyConfiguration)ProxyConfiguration.builder().endpoint(URI.create("http://localhost:7777")).username("user").password("secret").build();
        software.amazon.awssdk.http.nio.netty.ProxyConfiguration nettyProxy = (software.amazon.awssdk.http.nio.netty.ProxyConfiguration)software.amazon.awssdk.http.nio.netty.ProxyConfiguration.builder().scheme(proxy.scheme()).host(proxy.host()).port(proxy.port()).username(proxy.username()).password(proxy.password()).nonProxyHosts(proxy.nonProxyHosts()).build();
        this.builder = (AwsBuilder)Mockito.mock(AwsAsyncBuilder.class);
        Mockito.when((Object)this.awsOptions.getProxyConfiguration()).thenReturn((Object)proxy);
        ClientBuilderFactory.getFactory((AwsOptions)this.awsOptions).create((AwsClientBuilder)this.builder, this.awsOptions);
        ArgumentCaptor httpClientBuilder = ArgumentCaptor.forClass(NettyNioAsyncHttpClient.Builder.class);
        ((AwsAsyncBuilder)Mockito.verify((Object)((AwsAsyncBuilder)this.builder))).httpClientBuilder((SdkAsyncHttpClient.Builder)httpClientBuilder.capture());
        ((NettyNioAsyncHttpClient.Builder)Mockito.verify((Object)((NettyNioAsyncHttpClient.Builder)httpClientBuilder.getValue()))).proxyConfiguration(nettyProxy);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{httpClientBuilder.getValue()});
    }

    @Test
    public void testSyncHttpConfiguration() {
        this.testSyncHttpConfiguration(HttpClientConfiguration.builder().connectionAcquisitionTimeout(Integer.valueOf(100)).connectionMaxIdleTime(Integer.valueOf(200)).connectionTimeout(Integer.valueOf(300)).connectionTimeToLive(Integer.valueOf(400)).socketTimeout(Integer.valueOf(500)).maxConnections(Integer.valueOf(10)).build(), builder -> {
            ((ApacheHttpClient.Builder)Mockito.verify((Object)builder)).connectionAcquisitionTimeout(Duration.ofMillis(100L));
            ((ApacheHttpClient.Builder)Mockito.verify((Object)builder)).connectionMaxIdleTime(Duration.ofMillis(200L));
            ((ApacheHttpClient.Builder)Mockito.verify((Object)builder)).connectionTimeout(Duration.ofMillis(300L));
            ((ApacheHttpClient.Builder)Mockito.verify((Object)builder)).connectionTimeToLive(Duration.ofMillis(400L));
            ((ApacheHttpClient.Builder)Mockito.verify((Object)builder)).socketTimeout(Duration.ofMillis(500L));
            ((ApacheHttpClient.Builder)Mockito.verify((Object)builder)).maxConnections(Integer.valueOf(10));
        });
    }

    @Test
    public void testSyncEmptyHttpConfiguration() {
        this.testSyncHttpConfiguration(HttpClientConfiguration.builder().build(), builder -> {});
    }

    public void testSyncHttpConfiguration(HttpClientConfiguration conf, Consumer<ApacheHttpClient.Builder> verification) {
        this.builder = (AwsBuilder)Mockito.mock(AwsSyncBuilder.class);
        Mockito.when((Object)this.awsOptions.getHttpClientConfiguration()).thenReturn((Object)conf);
        ClientBuilderFactory.getFactory((AwsOptions)this.awsOptions).create((AwsClientBuilder)this.builder, this.awsOptions);
        ArgumentCaptor httpClientBuilder = ArgumentCaptor.forClass(ApacheHttpClient.Builder.class);
        ((AwsSyncBuilder)Mockito.verify((Object)((AwsSyncBuilder)this.builder))).httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder.capture());
        verification.accept((ApacheHttpClient.Builder)httpClientBuilder.getValue());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{httpClientBuilder.getValue()});
    }

    @Test
    public void testAsyncHttpConfiguration() {
        this.testAsyncHttpConfiguration(HttpClientConfiguration.builder().connectionAcquisitionTimeout(Integer.valueOf(100)).connectionMaxIdleTime(Integer.valueOf(200)).connectionTimeout(Integer.valueOf(300)).connectionTimeToLive(Integer.valueOf(400)).socketTimeout(Integer.valueOf(400)).readTimeout(Integer.valueOf(500)).writeTimeout(Integer.valueOf(600)).maxConnections(Integer.valueOf(10)).build(), builder -> {
            ((NettyNioAsyncHttpClient.Builder)Mockito.verify((Object)builder)).maxConcurrency(Integer.valueOf(10));
            ((NettyNioAsyncHttpClient.Builder)Mockito.verify((Object)builder)).connectionAcquisitionTimeout(Duration.ofMillis(100L));
            ((NettyNioAsyncHttpClient.Builder)Mockito.verify((Object)builder)).connectionMaxIdleTime(Duration.ofMillis(200L));
            ((NettyNioAsyncHttpClient.Builder)Mockito.verify((Object)builder)).connectionTimeout(Duration.ofMillis(300L));
            ((NettyNioAsyncHttpClient.Builder)Mockito.verify((Object)builder)).connectionTimeToLive(Duration.ofMillis(400L));
            InOrder ordered = Mockito.inOrder((Object[])new Object[]{builder});
            ((NettyNioAsyncHttpClient.Builder)ordered.verify(builder)).readTimeout(Duration.ofMillis(400L));
            ((NettyNioAsyncHttpClient.Builder)ordered.verify(builder)).readTimeout(Duration.ofMillis(500L));
            ordered = Mockito.inOrder((Object[])new Object[]{builder});
            ((NettyNioAsyncHttpClient.Builder)ordered.verify(builder)).writeTimeout(Duration.ofMillis(400L));
            ((NettyNioAsyncHttpClient.Builder)ordered.verify(builder)).writeTimeout(Duration.ofMillis(600L));
        });
    }

    @Test
    public void testAsyncHttpSocketConfiguration() {
        this.testAsyncHttpConfiguration(HttpClientConfiguration.builder().socketTimeout(Integer.valueOf(400)).build(), builder -> {
            ((NettyNioAsyncHttpClient.Builder)Mockito.verify((Object)builder)).readTimeout(Duration.ofMillis(400L));
            ((NettyNioAsyncHttpClient.Builder)Mockito.verify((Object)builder)).writeTimeout(Duration.ofMillis(400L));
        });
    }

    @Test
    public void testAsyncEmptyHttpConfiguration() {
        this.testAsyncHttpConfiguration(HttpClientConfiguration.builder().build(), builder -> {});
    }

    public void testAsyncHttpConfiguration(HttpClientConfiguration conf, Consumer<NettyNioAsyncHttpClient.Builder> verification) {
        this.builder = (AwsBuilder)Mockito.mock(AwsAsyncBuilder.class);
        Mockito.when((Object)this.awsOptions.getHttpClientConfiguration()).thenReturn((Object)conf);
        ClientBuilderFactory.getFactory((AwsOptions)this.awsOptions).create((AwsClientBuilder)this.builder, this.awsOptions);
        ArgumentCaptor httpClientBuilder = ArgumentCaptor.forClass(NettyNioAsyncHttpClient.Builder.class);
        ((AwsAsyncBuilder)Mockito.verify((Object)((AwsAsyncBuilder)this.builder))).httpClientBuilder((SdkAsyncHttpClient.Builder)httpClientBuilder.capture());
        verification.accept((NettyNioAsyncHttpClient.Builder)httpClientBuilder.getValue());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{httpClientBuilder.getValue()});
    }

    private static class TestClientBuilderFactory
    extends ClientBuilderFactory.DefaultClientBuilder {
        private TestClientBuilderFactory() {
        }

        ApacheHttpClient.Builder syncClientBuilder() {
            return (ApacheHttpClient.Builder)Mockito.mock(ApacheHttpClient.Builder.class);
        }

        NettyNioAsyncHttpClient.Builder asyncClientBuilder() {
            return (NettyNioAsyncHttpClient.Builder)Mockito.mock(NettyNioAsyncHttpClient.Builder.class);
        }
    }

    private static abstract class AwsAsyncBuilder
    extends AwsBuilder
    implements SdkAsyncClientBuilder<AwsAsyncBuilder, Void> {
        private AwsAsyncBuilder() {
        }
    }

    private static abstract class AwsSyncBuilder
    extends AwsBuilder
    implements SdkSyncClientBuilder<AwsSyncBuilder, Void> {
        private AwsSyncBuilder() {
        }
    }

    private static abstract class AwsBuilder
    implements AwsClientBuilder<AwsBuilder, Void> {
        private AwsBuilder() {
        }
    }
}

