/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.aws2.common.ClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.common.ClientConfiguration;
import org.apache.beam.sdk.io.aws2.options.AwsOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.testing.TestPipeline;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;

public class MockClientBuilderFactory
implements ClientBuilderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MockClientBuilderFactory.class);
    private static final WeakHashMap<PipelineOptions, Map<Class<? extends AwsClientBuilder>, AwsClientBuilder>> CLIENTS = new WeakHashMap();

    public static <BuilderT extends AwsClientBuilder<BuilderT, ClientT>, ClientT> void set(TestPipeline pipeline, Class<BuilderT> builderClass, ClientT clientT) {
        MockClientBuilderFactory.set(pipeline.getOptions(), builderClass, clientT);
    }

    public static <BuilderT extends AwsClientBuilder<BuilderT, ClientT>, ClientT> void set(PipelineOptions options, Class<BuilderT> builderClass, ClientT clientT) {
        ((AwsOptions)options.as(AwsOptions.class)).setClientBuilderFactory(MockClientBuilderFactory.class);
        AwsClientBuilder builder = (AwsClientBuilder)Mockito.mock(builderClass);
        Mockito.when((Object)builder.build()).thenReturn(clientT);
        CLIENTS.computeIfAbsent(options, ignore -> new HashMap()).put(builderClass, builder);
    }

    public <BuilderT extends AwsClientBuilder<BuilderT, ClientT>, ClientT> BuilderT create(BuilderT builder, ClientConfiguration clientConfig, @Nullable AwsOptions options) {
        Optional<Map.Entry> mock = CLIENTS.entrySet().stream().filter(kv -> ((PipelineOptions)kv.getKey()).getOptionsId() == options.getOptionsId()).flatMap(kv -> ((Map)kv.getValue()).entrySet().stream()).filter(b -> ((Class)b.getKey()).isInstance(builder)).findFirst();
        if (mock.isPresent()) {
            return (BuilderT)((AwsClientBuilder)mock.get().getValue());
        }
        Class<?> builderType = builder.getClass().getInterfaces()[0];
        LOG.warn("No mock configured for {}, returning empty mock.", (Object)builderType.getSimpleName());
        return (BuilderT)((AwsClientBuilder)Mockito.mock(builderType));
    }

    public void checkConfiguration(ClientConfiguration clientConfig, @Nullable AwsOptions options) {
    }
}

