/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2;

import java.util.List;
import java.util.function.Consumer;
import org.apache.beam.sdk.io.aws2.options.AwsOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.ExternalResource;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.localstack.LocalStackContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.utility.DockerImageName;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.regions.Region;

public class ITEnvironment<OptionsT extends ITOptions>
extends ExternalResource {
    private static final String LOCALSTACK = "localstack/localstack";
    private static final String LOCALSTACK_VERSION = "0.13.1";
    private final OptionsT options;
    private final LocalStackContainer localstack;

    public ITEnvironment(LocalStackContainer.Service service, Class<OptionsT> optionsClass, String ... env) {
        this(new LocalStackContainer.Service[]{service}, optionsClass, env);
    }

    public ITEnvironment(LocalStackContainer.Service[] services, Class<OptionsT> optionsClass, String ... env) {
        this.localstack = (LocalStackContainer)new LocalStackContainer(DockerImageName.parse((String)LOCALSTACK).withTag(LOCALSTACK_VERSION)).withServices(services).withStartupAttempts(3);
        PipelineOptionsFactory.register(optionsClass);
        this.options = (ITOptions)TestPipeline.testingPipelineOptions().as(optionsClass);
        this.localstack.setEnv((List)ImmutableList.copyOf((Object[])env));
        if (this.options.getLocalstackLogLevel() != null) {
            ((LocalStackContainer)this.localstack.withEnv("LS_LOG", this.options.getLocalstackLogLevel())).withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)StringUtils.join((Object[])services))));
        }
    }

    public TestPipeline createTestPipeline() {
        return TestPipeline.fromOptions(this.options);
    }

    public <BuilderT extends AwsClientBuilder<BuilderT, ClientT>, ClientT> ClientT buildClient(BuilderT builder) {
        if (this.options.getEndpoint() != null) {
            builder.endpointOverride(this.options.getEndpoint());
        }
        return (ClientT)builder.credentialsProvider(this.options.getAwsCredentialsProvider()).region(this.options.getAwsRegion()).build();
    }

    public OptionsT options() {
        return this.options;
    }

    protected void before() {
        if (this.options.getUseLocalstack().booleanValue()) {
            this.startLocalstack();
        }
    }

    protected void after() {
        this.localstack.stop();
    }

    private void startLocalstack() {
        this.localstack.start();
        this.options.setEndpoint(this.localstack.getEndpointOverride(LocalStackContainer.Service.S3));
        this.options.setAwsRegion(Region.of((String)this.localstack.getRegion()));
        this.options.setAwsCredentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.localstack.getAccessKey(), (String)this.localstack.getSecretKey())));
    }

    public static interface ITOptions
    extends AwsOptions,
    TestPipelineOptions {
        @Description(value="Number of rows to write and read by the test")
        @Default.Integer(value=1000)
        public Integer getNumberOfRows();

        public void setNumberOfRows(Integer var1);

        @Description(value="Flag if to use localstack, enabled by default.")
        @Default.Boolean(value=true)
        public Boolean getUseLocalstack();

        public void setUseLocalstack(Boolean var1);

        @Description(value="Localstack log level, e.g. trace, debug, info")
        public String getLocalstackLogLevel();

        public void setLocalstackLogLevel(String var1);
    }
}

