/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.beam.sdk.io.aws2.sqs.AutoValue_SqsMessage;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoValue
public abstract class SqsMessage
implements Serializable {
    abstract @Nullable String getBody();

    abstract @Nullable String getMessageId();

    abstract @Nullable String getReceiptHandle();

    abstract @Nullable String getTimeStamp();

    abstract @Nullable String getRequestTimeStamp();

    abstract Builder toBuilder();

    static SqsMessage create(String body, String messageId, String receiptHandle, String timeStamp, String requestTimeStamp) {
        Preconditions.checkArgument((body != null ? 1 : 0) != 0, (Object)"body can not be null");
        Preconditions.checkArgument((messageId != null ? 1 : 0) != 0, (Object)"messageId can not be null");
        Preconditions.checkArgument((receiptHandle != null ? 1 : 0) != 0, (Object)"receiptHandle can not be null");
        Preconditions.checkArgument((timeStamp != null ? 1 : 0) != 0, (Object)"timeStamp can not be null");
        Preconditions.checkArgument((requestTimeStamp != null ? 1 : 0) != 0, (Object)"requestTimeStamp can not be null");
        return new AutoValue_SqsMessage.Builder().setBody(body).setMessageId(messageId).setReceiptHandle(receiptHandle).setTimeStamp(timeStamp).setRequestTimeStamp(requestTimeStamp).build();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setBody(String var1);

        abstract Builder setMessageId(String var1);

        abstract Builder setReceiptHandle(String var1);

        abstract Builder setTimeStamp(String var1);

        abstract Builder setRequestTimeStamp(String var1);

        abstract SqsMessage build();
    }
}

