/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws2.sqs.SqsUnboundedReader;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Objects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;

class SqsCheckpointMark
implements UnboundedSource.CheckpointMark,
Serializable {
    private transient Optional<SqsUnboundedReader> reader;
    private @Nullable List<String> safeToDeleteIds;
    @VisibleForTesting
    final List<String> notYetReadReceipts;

    SqsCheckpointMark(SqsUnboundedReader reader, List<String> messagesToDelete, List<String> notYetReadReceipts) {
        this.reader = Optional.of(reader);
        this.safeToDeleteIds = ImmutableList.copyOf(messagesToDelete);
        this.notYetReadReceipts = ImmutableList.copyOf(notYetReadReceipts);
    }

    public void finalizeCheckpoint() throws IOException {
        Preconditions.checkState((this.reader.isPresent() && this.safeToDeleteIds != null ? 1 : 0) != 0, (Object)"Cannot finalize a restored checkpoint");
        try {
            this.reader.get().delete(this.safeToDeleteIds);
            int remainingInFlight = this.reader.get().numInFlightCheckpoints.decrementAndGet();
            Preconditions.checkState((remainingInFlight >= 0 ? 1 : 0) != 0, (Object)"Miscounted in-flight checkpoints");
        }
        catch (Throwable throwable) {
            int remainingInFlight = this.reader.get().numInFlightCheckpoints.decrementAndGet();
            Preconditions.checkState((remainingInFlight >= 0 ? 1 : 0) != 0, (Object)"Miscounted in-flight checkpoints");
            this.reader.get().maybeCloseClient();
            this.reader = Optional.empty();
            this.safeToDeleteIds = null;
            throw throwable;
        }
        this.reader.get().maybeCloseClient();
        this.reader = Optional.empty();
        this.safeToDeleteIds = null;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqsCheckpointMark that = (SqsCheckpointMark)o;
        return Objects.equal(this.safeToDeleteIds, that.safeToDeleteIds);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.safeToDeleteIds});
    }
}

