/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import software.amazon.awssdk.services.sqs.model.Message;

public class MessageCoder
extends AtomicCoder<Message>
implements Serializable {
    private static final MessageCoder INSTANCE = new MessageCoder();

    private MessageCoder() {
    }

    static MessageCoder of() {
        return INSTANCE;
    }

    public void encode(Message value, OutputStream outStream) throws IOException {
        StringUtf8Coder.of().encode(value.messageId(), outStream);
        StringUtf8Coder.of().encode(value.body(), outStream);
    }

    public Message decode(InputStream inStream) throws IOException {
        String messageId = StringUtf8Coder.of().decode(inStream);
        String body = StringUtf8Coder.of().decode(inStream);
        return (Message)Message.builder().messageId(messageId).body(body).build();
    }
}

