/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sns;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.io.aws2.sns.SnsResponse;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

class SnsResponseCoder<T>
extends StructuredCoder<SnsResponse<T>> {
    private final Coder<T> elementCoder;
    private static final VarIntCoder STATUS_CODE_CODER = VarIntCoder.of();
    private static final StringUtf8Coder STATUS_TEXT_CODER = StringUtf8Coder.of();

    public SnsResponseCoder(Coder<T> elementCoder) {
        this.elementCoder = elementCoder;
    }

    static <T> SnsResponseCoder<T> of(Coder<T> elementCoder) {
        return new SnsResponseCoder<T>(elementCoder);
    }

    public void encode(SnsResponse<T> value, OutputStream outStream) throws IOException {
        T element = value.element();
        this.elementCoder.encode(element, outStream);
        OptionalInt statusCode = value.statusCode();
        if (statusCode.isPresent()) {
            BooleanCoder.of().encode(Boolean.TRUE, outStream);
            STATUS_CODE_CODER.encode(Integer.valueOf(statusCode.getAsInt()), outStream);
        } else {
            BooleanCoder.of().encode(Boolean.FALSE, outStream);
        }
        Optional<String> statusText = value.statusText();
        if (statusText.isPresent()) {
            BooleanCoder.of().encode(Boolean.TRUE, outStream);
            STATUS_TEXT_CODER.encode(statusText.get(), outStream);
        } else {
            BooleanCoder.of().encode(Boolean.FALSE, outStream);
        }
    }

    public SnsResponse<T> decode(InputStream inStream) throws IOException {
        Object element = this.elementCoder.decode(inStream);
        OptionalInt statusCode = OptionalInt.empty();
        if (BooleanCoder.of().decode(inStream).booleanValue()) {
            statusCode = OptionalInt.of(STATUS_CODE_CODER.decode(inStream));
        }
        Optional<String> statusText = Optional.empty();
        if (BooleanCoder.of().decode(inStream).booleanValue()) {
            statusText = Optional.of(STATUS_TEXT_CODER.decode(inStream));
        }
        return SnsResponse.create(element, statusCode, statusText);
    }

    public List<? extends Coder<?>> getCoderArguments() {
        return ImmutableList.of(this.elementCoder);
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.elementCoder.verifyDeterministic();
    }
}

