/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sns;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.beam.sdk.io.aws2.sns.AutoValue_SnsResponse;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.awssdk.services.sns.model.PublishResponse;

@AutoValue
abstract class SnsResponse<T>
implements Serializable {
    SnsResponse() {
    }

    public abstract T element();

    public abstract OptionalInt statusCode();

    public abstract Optional<String> statusText();

    static <T> SnsResponse<T> create(@NonNull T element, OptionalInt statusCode, Optional<String> statusText) {
        return new AutoValue_SnsResponse<T>(element, statusCode, statusText);
    }

    public static <T> SnsResponse<T> of(@NonNull T element, @Nullable PublishResponse response) {
        Optional<PublishResponse> publishResponse = Optional.ofNullable(response);
        OptionalInt statusCode = publishResponse.map(r -> OptionalInt.of(r.sdkHttpResponse().statusCode())).orElse(OptionalInt.empty());
        Optional<String> statusText = publishResponse.flatMap(r -> r.sdkHttpResponse().statusText());
        return SnsResponse.create(element, statusCode, statusText);
    }
}

