/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sns;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import software.amazon.awssdk.services.sns.model.PublishResponse;

public class PublishResponseCoder
extends AtomicCoder<PublishResponse>
implements Serializable {
    private static final PublishResponseCoder INSTANCE = new PublishResponseCoder();

    private PublishResponseCoder() {
    }

    static PublishResponseCoder of() {
        return INSTANCE;
    }

    public void encode(PublishResponse value, OutputStream outStream) throws IOException {
        StringUtf8Coder.of().encode(value.messageId(), outStream);
    }

    public PublishResponse decode(InputStream inStream) throws IOException {
        String messageId = StringUtf8Coder.of().decode(inStream);
        return (PublishResponse)PublishResponse.builder().messageId(messageId).build();
    }
}

