/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.s3;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.commons.codec.digest.DigestUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SSECustomerKey {
    private final @Nullable String key;
    private final @Nullable String algorithm;
    private final @Nullable String md5;

    private SSECustomerKey(Builder builder) {
        Preconditions.checkArgument((builder.key == null && builder.algorithm == null || builder.key != null && builder.algorithm != null ? 1 : 0) != 0, (Object)"Encryption key and algorithm for SSE-C encryption must be specified in pairs");
        this.key = builder.key;
        this.algorithm = builder.algorithm;
        this.md5 = builder.md5 == null && this.key != null ? Base64.getEncoder().encodeToString(DigestUtils.md5((byte[])Base64.getDecoder().decode(this.key.getBytes(StandardCharsets.UTF_8)))) : builder.md5;
    }

    public @Nullable String getKey() {
        return this.key;
    }

    public @Nullable String getAlgorithm() {
        return this.algorithm;
    }

    public @Nullable String getMD5() {
        return this.md5;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private @Nullable String key;
        private @Nullable String algorithm;
        private @Nullable String md5;

        private Builder() {
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder md5(String md5) {
            this.md5 = md5;
            return this;
        }

        public SSECustomerKey build() {
            return new SSECustomerKey(this);
        }
    }
}

