/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.s3;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Objects;
import org.apache.beam.sdk.io.aws2.options.S3Options;
import org.apache.beam.sdk.io.aws2.s3.S3ResourceId;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;

class S3WritableByteChannel
implements WritableByteChannel {
    private final S3Client s3Client;
    private final S3Options options;
    private final S3ResourceId path;
    private final String uploadId;
    private final ByteBuffer uploadBuffer;
    private int partNumber = 1;
    private boolean open = true;
    private final MessageDigest md5 = S3WritableByteChannel.md5();
    private final ArrayList<CompletedPart> completedParts;

    S3WritableByteChannel(S3Client s3, S3ResourceId path, String contentType, S3Options options) throws IOException {
        CreateMultipartUploadResponse response;
        this.s3Client = (S3Client)Preconditions.checkNotNull((Object)s3, (Object)"s3Client");
        this.options = (S3Options)Preconditions.checkNotNull((Object)options);
        this.path = (S3ResourceId)Preconditions.checkNotNull((Object)path, (Object)"path");
        String awsKms = ServerSideEncryption.AWS_KMS.toString();
        Preconditions.checkArgument((boolean)S3WritableByteChannel.atMostOne(options.getSSECustomerKey().getKey() != null, Objects.equals(options.getSSEAlgorithm(), awsKms) || options.getSSEKMSKeyId() != null, options.getSSEAlgorithm() != null && !options.getSSEAlgorithm().equals(awsKms)), (Object)"Either SSECustomerKey (SSE-C) or SSEAlgorithm (SSE-S3) or SSEAwsKeyManagementParams (SSE-KMS) must not be set at the same time.");
        Preconditions.checkArgument((options.getS3UploadBufferSizeBytes() >= 0x500000 ? 1 : 0) != 0, (String)"S3UploadBufferSizeBytes must be at least %s bytes", (int)0x500000);
        this.uploadBuffer = ByteBuffer.allocate(options.getS3UploadBufferSizeBytes());
        this.completedParts = new ArrayList();
        CreateMultipartUploadRequest createMultipartUploadRequest = (CreateMultipartUploadRequest)CreateMultipartUploadRequest.builder().bucket(path.getBucket()).key(path.getKey()).storageClass(options.getS3StorageClass()).contentType(contentType).serverSideEncryption(options.getSSEAlgorithm()).sseCustomerKey(options.getSSECustomerKey().getKey()).sseCustomerAlgorithm(options.getSSECustomerKey().getAlgorithm()).ssekmsKeyId(options.getSSEKMSKeyId()).sseCustomerKeyMD5(options.getSSECustomerKey().getMD5()).build();
        try {
            response = this.s3Client.createMultipartUpload(createMultipartUploadRequest);
        }
        catch (SdkClientException e) {
            throw new IOException(e);
        }
        this.uploadId = response.uploadId();
    }

    private static MessageDigest md5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int write(ByteBuffer sourceBuffer) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        int totalBytesWritten = 0;
        while (sourceBuffer.hasRemaining()) {
            int bytesWritten = Math.min(sourceBuffer.remaining(), this.uploadBuffer.remaining());
            totalBytesWritten += bytesWritten;
            byte[] copyBuffer = new byte[bytesWritten];
            sourceBuffer.get(copyBuffer);
            this.uploadBuffer.put(copyBuffer);
            this.md5.update(copyBuffer);
            if (this.uploadBuffer.hasRemaining() && !sourceBuffer.hasRemaining()) continue;
            this.flush();
        }
        return totalBytesWritten;
    }

    private void flush() throws IOException {
        UploadPartResponse response;
        this.uploadBuffer.flip();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.uploadBuffer.array());
        UploadPartRequest request = (UploadPartRequest)UploadPartRequest.builder().bucket(this.path.getBucket()).key(this.path.getKey()).uploadId(this.uploadId).partNumber(Integer.valueOf(this.partNumber++)).contentLength(Long.valueOf(this.uploadBuffer.remaining())).sseCustomerKey(this.options.getSSECustomerKey().getKey()).sseCustomerAlgorithm(this.options.getSSECustomerKey().getAlgorithm()).sseCustomerKeyMD5(this.options.getSSECustomerKey().getMD5()).contentMD5(Base64.getEncoder().encodeToString(this.md5.digest())).build();
        try {
            response = this.s3Client.uploadPart(request, RequestBody.fromInputStream((InputStream)inputStream, (long)request.contentLength()));
        }
        catch (SdkClientException e) {
            throw new IOException(e);
        }
        CompletedPart part = (CompletedPart)CompletedPart.builder().partNumber(request.partNumber()).eTag(response.eTag()).build();
        this.uploadBuffer.clear();
        this.md5.reset();
        this.completedParts.add(part);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        if (this.uploadBuffer.remaining() > 0) {
            this.flush();
        }
        CompletedMultipartUpload completedMultipartUpload = (CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(this.completedParts).build();
        CompleteMultipartUploadRequest request = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(this.path.getBucket()).key(this.path.getKey()).uploadId(this.uploadId).multipartUpload(completedMultipartUpload).build();
        try {
            this.s3Client.completeMultipartUpload(request);
        }
        catch (SdkClientException e) {
            throw new IOException(e);
        }
    }

    @VisibleForTesting
    static boolean atMostOne(boolean ... values) {
        boolean one = false;
        for (boolean value : values) {
            if (!one && value) {
                one = true;
                continue;
            }
            if (!value) continue;
            return false;
        }
        return true;
    }
}

