/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.s3;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import org.apache.beam.sdk.io.aws2.options.S3Options;
import org.apache.beam.sdk.io.aws2.s3.S3ResourceId;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.utils.IoUtils;

class S3ReadableSeekableByteChannel
implements SeekableByteChannel {
    private final S3Client s3Client;
    private final S3ResourceId path;
    private final S3Options options;
    private final long contentLength;
    private long position = 0L;
    private boolean open = true;
    private @Nullable ResponseInputStream<GetObjectResponse> s3ResponseInputStream;
    private @Nullable ReadableByteChannel s3ObjectContentChannel;

    S3ReadableSeekableByteChannel(S3Client s3Client, S3ResourceId path, S3Options options) throws IOException {
        this.s3Client = (S3Client)Preconditions.checkNotNull((Object)s3Client, (Object)"s3Client");
        Preconditions.checkNotNull((Object)path, (Object)"path");
        this.options = (S3Options)Preconditions.checkNotNull((Object)options, (Object)"options");
        if (path.getSize().isPresent()) {
            this.contentLength = (Long)path.getSize().get();
            this.path = path;
        } else {
            HeadObjectRequest request = (HeadObjectRequest)HeadObjectRequest.builder().bucket(path.getBucket()).key(path.getKey()).build();
            try {
                this.contentLength = s3Client.headObject(request).contentLength();
            }
            catch (SdkClientException e) {
                throw new IOException(e);
            }
            this.path = path.withSize(this.contentLength);
        }
    }

    @Override
    public int read(ByteBuffer destinationBuffer) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!destinationBuffer.hasRemaining()) {
            return 0;
        }
        if (this.position == this.contentLength) {
            return -1;
        }
        if (this.s3ResponseInputStream == null) {
            GetObjectRequest.Builder builder = GetObjectRequest.builder().bucket(this.path.getBucket()).key(this.path.getKey()).sseCustomerKey(this.options.getSSECustomerKey().getKey()).sseCustomerAlgorithm(this.options.getSSECustomerKey().getAlgorithm());
            if (this.position > 0L) {
                builder.range(String.format("bytes=%s-%s", this.position, this.contentLength));
            }
            GetObjectRequest request = (GetObjectRequest)builder.build();
            try {
                this.s3ResponseInputStream = this.s3Client.getObject(request);
            }
            catch (SdkClientException e) {
                throw new IOException(e);
            }
            this.s3ObjectContentChannel = Channels.newChannel(new BufferedInputStream((InputStream)this.s3ResponseInputStream, 0x100000));
        }
        int totalBytesRead = 0;
        int bytesRead = 0;
        do {
            totalBytesRead += bytesRead;
            try {
                bytesRead = this.s3ObjectContentChannel.read(destinationBuffer);
            }
            catch (SdkServiceException e) {
                throw new IOException(e);
            }
        } while (bytesRead > 0);
        this.position += (long)totalBytesRead;
        return totalBytesRead;
    }

    @Override
    public long position() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        Preconditions.checkArgument((newPosition >= 0L ? 1 : 0) != 0, (Object)"newPosition too low");
        Preconditions.checkArgument((newPosition < this.contentLength ? 1 : 0) != 0, (Object)"new position too high");
        if (newPosition == this.position) {
            return this;
        }
        if (this.s3ResponseInputStream != null) {
            this.s3ResponseInputStream.close();
            this.s3ResponseInputStream = null;
        }
        this.position = newPosition;
        return this;
    }

    @Override
    public long size() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.contentLength;
    }

    @Override
    public void close() throws IOException {
        if (this.s3ResponseInputStream != null) {
            IoUtils.drainInputStream(this.s3ResponseInputStream);
            this.s3ResponseInputStream.close();
        }
        this.open = false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public int write(ByteBuffer src) {
        throw new NonWritableChannelException();
    }

    @Override
    public SeekableByteChannel truncate(long size) {
        throw new NonWritableChannelException();
    }
}

