/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.s3;

import java.net.URI;
import org.apache.beam.sdk.io.aws2.options.S3ClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.options.S3Options;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public class DefaultS3ClientBuilderFactory
implements S3ClientBuilderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultS3ClientBuilderFactory.class);

    @Override
    public S3ClientBuilder createBuilder(S3Options s3Options) {
        S3ClientBuilder builder = (S3ClientBuilder)S3Client.builder().credentialsProvider(s3Options.getAwsCredentialsProvider());
        if (s3Options.getProxyConfiguration() != null) {
            SdkHttpClient httpClient = ApacheHttpClient.builder().proxyConfiguration(s3Options.getProxyConfiguration()).build();
            builder = (S3ClientBuilder)builder.httpClient(httpClient);
        }
        if (!Strings.isNullOrEmpty((String)s3Options.getEndpoint())) {
            URI endpoint = URI.create(s3Options.getEndpoint());
            Region region = Region.of((String)s3Options.getAwsRegion());
            ((S3ClientBuilder)builder.endpointOverride(endpoint)).region(region);
        } else if (!Strings.isNullOrEmpty((String)s3Options.getAwsRegion())) {
            builder = (S3ClientBuilder)builder.region(Region.of((String)s3Options.getAwsRegion()));
        } else {
            LOG.info("The AWS S3 Beam extension was included in this build, but the awsRegion flag was not specified. If you don't plan to use S3, then ignore this message.");
        }
        return builder;
    }
}

