/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.options;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.beam.sdk.io.aws2.options.AwsModule;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class AwsSerializableUtils {
    public static String serializeAwsCredentialsProvider(AwsCredentialsProvider awsCredentialsProvider) {
        ObjectMapper om = new ObjectMapper();
        om.registerModule((Module)new AwsModule());
        try {
            return om.writeValueAsString((Object)awsCredentialsProvider);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("AwsCredentialsProvider can not be serialized to Json", e);
        }
    }

    public static AwsCredentialsProvider deserializeAwsCredentialsProvider(String awsCredentialsProviderSerialized) {
        ObjectMapper om = new ObjectMapper();
        om.registerModule((Module)new AwsModule());
        try {
            return (AwsCredentialsProvider)om.readValue(awsCredentialsProviderSerialized, AwsCredentialsProvider.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("AwsCredentialsProvider can not be deserialized from Json", e);
        }
    }
}

