/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.options;

import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.Validation;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.utils.AttributeMap;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public interface AwsOptions
extends PipelineOptions {
    @Description(value="AWS region used by the AWS client")
    @Validation.Required
    public String getAwsRegion();

    public void setAwsRegion(String var1);

    @Description(value="AWS service endpoint used by the AWS client")
    public String getEndpoint();

    public void setEndpoint(String var1);

    @Description(value="The credential instance that should be used to authenticate against AWS services. The option value must contain \"@type\" field and an AWS Credentials Provider class name as the field value. Refer to DefaultAWSCredentialsProviderChain Javadoc for usage help. For example, to specify the AWS key ID and secret, specify the following: {\"@type\": \"StaticCredentialsProvider\", \"accessKeyId\":\"<key_id>\", \"secretAccessKey\":\"<secret_key>\"}")
    @Default.InstanceFactory(value=AwsUserCredentialsFactory.class)
    public AwsCredentialsProvider getAwsCredentialsProvider();

    public void setAwsCredentialsProvider(AwsCredentialsProvider var1);

    @Description(value="The proxy configuration instance that should be used to configure AWS service clients. Please note that the configuration deserialization only allows one to specify proxy settings. For example, to specify the proxy endpoint, username and password, specify the following: --proxyConfiguration={\"endpoint\":\"http://hostname:port\", \"username\":\"username\", \"password\":\"password\"}")
    public ProxyConfiguration getProxyConfiguration();

    public void setProxyConfiguration(ProxyConfiguration var1);

    @Description(value="The attribute map instance that should be used to configure AWS http client configuration parameters.Mentioned parameters are the available parameters that can be set. All above parameters are optional set only those that need custom changes.")
    public AttributeMap getAttributeMap();

    public void setAttributeMap(AttributeMap var1);

    public static class AwsUserCredentialsFactory
    implements DefaultValueFactory<AwsCredentialsProvider> {
        public AwsCredentialsProvider create(PipelineOptions options) {
            return DefaultCredentialsProvider.create();
        }
    }
}

