/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.options;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.aws2.s3.SSECustomerKey;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.auth.credentials.SystemPropertyCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.utils.AttributeMap;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class AwsModule
extends SimpleModule {
    private static final String ACCESS_KEY_ID = "accessKeyId";
    private static final String SECRET_ACCESS_KEY = "secretAccessKey";
    private static final String SESSION_TOKEN = "sessionToken";
    public static final String CONNECTION_ACQUIRE_TIMEOUT = "connectionAcquisitionTimeout";
    public static final String CONNECTION_MAX_IDLE_TIMEOUT = "connectionMaxIdleTime";
    public static final String CONNECTION_TIMEOUT = "connectionTimeout";
    public static final String CONNECTION_TIME_TO_LIVE = "connectionTimeToLive";
    public static final String MAX_CONNECTIONS = "maxConnections";
    public static final String READ_TIMEOUT = "socketTimeout";

    public AwsModule() {
        super("AwsModule");
        this.setMixInAnnotation(AwsCredentialsProvider.class, AwsCredentialsProviderMixin.class);
        this.setMixInAnnotation(ProxyConfiguration.class, ProxyConfigurationMixin.class);
        this.setMixInAnnotation(AttributeMap.class, AttributeMapMixin.class);
        this.setMixInAnnotation(SSECustomerKey.class, SSECustomerKeyMixin.class);
    }

    private static class SSECustomerKeyDeserializer
    extends JsonDeserializer<SSECustomerKey> {
        private SSECustomerKeyDeserializer() {
        }

        public SSECustomerKey deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            Map asMap = (Map)parser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){});
            String key = asMap.getOrDefault("key", null);
            String algorithm = asMap.getOrDefault("algorithm", null);
            String md5 = asMap.getOrDefault("md5", null);
            return SSECustomerKey.builder().key(key).algorithm(algorithm).md5(md5).build();
        }
    }

    @JsonDeserialize(using=SSECustomerKeyDeserializer.class)
    private static class SSECustomerKeyMixin {
        private SSECustomerKeyMixin() {
        }
    }

    private static class AttributeMapSerializer
    extends JsonSerializer<AttributeMap> {
        private AttributeMapSerializer() {
        }

        public void serialize(AttributeMap attributeMap, JsonGenerator jsonGenerator, SerializerProvider serializer) throws IOException {
            jsonGenerator.writeStartObject();
            if (attributeMap.containsKey((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_ACQUIRE_TIMEOUT)) {
                jsonGenerator.writeStringField(AwsModule.CONNECTION_ACQUIRE_TIMEOUT, String.valueOf(attributeMap.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_ACQUIRE_TIMEOUT)));
            }
            if (attributeMap.containsKey((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_MAX_IDLE_TIMEOUT)) {
                jsonGenerator.writeStringField(AwsModule.CONNECTION_MAX_IDLE_TIMEOUT, String.valueOf(attributeMap.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_MAX_IDLE_TIMEOUT)));
            }
            if (attributeMap.containsKey((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT)) {
                jsonGenerator.writeStringField(AwsModule.CONNECTION_TIMEOUT, String.valueOf(attributeMap.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT)));
            }
            if (attributeMap.containsKey((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIME_TO_LIVE)) {
                jsonGenerator.writeStringField(AwsModule.CONNECTION_TIME_TO_LIVE, String.valueOf(attributeMap.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIME_TO_LIVE)));
            }
            if (attributeMap.containsKey((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS)) {
                jsonGenerator.writeStringField(AwsModule.MAX_CONNECTIONS, String.valueOf(attributeMap.get((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS)));
            }
            if (attributeMap.containsKey((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT)) {
                jsonGenerator.writeStringField(AwsModule.READ_TIMEOUT, String.valueOf(attributeMap.get((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT)));
            }
            jsonGenerator.writeEndObject();
        }
    }

    private static class AttributeMapDeserializer
    extends JsonDeserializer<AttributeMap> {
        private AttributeMapDeserializer() {
        }

        public AttributeMap deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            Map map = (Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){});
            AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
            if (map.containsKey(AwsModule.CONNECTION_ACQUIRE_TIMEOUT)) {
                attributeMapBuilder.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_ACQUIRE_TIMEOUT, (Object)Duration.parse((CharSequence)map.get(AwsModule.CONNECTION_ACQUIRE_TIMEOUT)));
            }
            if (map.containsKey(AwsModule.CONNECTION_MAX_IDLE_TIMEOUT)) {
                attributeMapBuilder.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_MAX_IDLE_TIMEOUT, (Object)Duration.parse((CharSequence)map.get(AwsModule.CONNECTION_MAX_IDLE_TIMEOUT)));
            }
            if (map.containsKey(AwsModule.CONNECTION_TIMEOUT)) {
                attributeMapBuilder.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT, (Object)Duration.parse((CharSequence)map.get(AwsModule.CONNECTION_TIMEOUT)));
            }
            if (map.containsKey(AwsModule.CONNECTION_TIME_TO_LIVE)) {
                attributeMapBuilder.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIME_TO_LIVE, (Object)Duration.parse((CharSequence)map.get(AwsModule.CONNECTION_TIME_TO_LIVE)));
            }
            if (map.containsKey(AwsModule.MAX_CONNECTIONS)) {
                attributeMapBuilder.put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS, (Object)Integer.parseInt((String)map.get(AwsModule.MAX_CONNECTIONS)));
            }
            if (map.containsKey(AwsModule.READ_TIMEOUT)) {
                attributeMapBuilder.put((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT, (Object)Duration.parse((CharSequence)map.get(AwsModule.READ_TIMEOUT)));
            }
            return attributeMapBuilder.build();
        }
    }

    @JsonSerialize(using=AttributeMapSerializer.class)
    @JsonDeserialize(using=AttributeMapDeserializer.class)
    private static class AttributeMapMixin {
        private AttributeMapMixin() {
        }
    }

    private static class ProxyConfigurationSerializer
    extends JsonSerializer<ProxyConfiguration> {
        private ProxyConfigurationSerializer() {
        }

        public void serialize(ProxyConfiguration proxyConfiguration, JsonGenerator jsonGenerator, SerializerProvider serializer) throws IOException {
            String endpoint = proxyConfiguration.scheme() + "://" + proxyConfiguration.host() + ":" + proxyConfiguration.port();
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("endpoint", endpoint);
            jsonGenerator.writeStringField("username", proxyConfiguration.username());
            jsonGenerator.writeStringField("password", proxyConfiguration.password());
            jsonGenerator.writeEndObject();
        }
    }

    private static class ProxyConfigurationDeserializer
    extends JsonDeserializer<ProxyConfiguration> {
        private ProxyConfigurationDeserializer() {
        }

        public ProxyConfiguration deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            Map asMap = (Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){});
            return (ProxyConfiguration)ProxyConfiguration.builder().endpoint(URI.create((String)asMap.get("endpoint"))).username((String)asMap.get("username")).password((String)asMap.get("password")).useSystemPropertyValues(Boolean.valueOf((String)asMap.get("useSystemPropertyValues"))).build();
        }
    }

    @JsonDeserialize(using=ProxyConfigurationDeserializer.class)
    @JsonSerialize(using=ProxyConfigurationSerializer.class)
    private static class ProxyConfigurationMixin {
        private ProxyConfigurationMixin() {
        }
    }

    private static class AWSCredentialsProviderSerializer
    extends JsonSerializer<AwsCredentialsProvider> {
        private static final ImmutableSet<Object> SINGLETON_CREDENTIAL_PROVIDERS = ImmutableSet.of(DefaultCredentialsProvider.class, EnvironmentVariableCredentialsProvider.class, SystemPropertyCredentialsProvider.class, ProfileCredentialsProvider.class, ContainerCredentialsProvider.class);

        private AWSCredentialsProviderSerializer() {
        }

        public void serialize(AwsCredentialsProvider credentialsProvider, JsonGenerator jsonGenerator, SerializerProvider serializer) throws IOException {
            serializer.defaultSerializeValue((Object)credentialsProvider, jsonGenerator);
        }

        public void serializeWithType(AwsCredentialsProvider credentialsProvider, JsonGenerator jsonGenerator, SerializerProvider serializer, TypeSerializer typeSerializer) throws IOException {
            typeSerializer.writeTypePrefixForObject((Object)credentialsProvider, jsonGenerator);
            if (credentialsProvider.getClass().equals(StaticCredentialsProvider.class)) {
                AwsCredentials credentials = credentialsProvider.resolveCredentials();
                if (credentials.getClass().equals(AwsSessionCredentials.class)) {
                    AwsSessionCredentials sessionCredentials = (AwsSessionCredentials)credentials;
                    jsonGenerator.writeStringField(AwsModule.ACCESS_KEY_ID, sessionCredentials.accessKeyId());
                    jsonGenerator.writeStringField(AwsModule.SECRET_ACCESS_KEY, sessionCredentials.secretAccessKey());
                    jsonGenerator.writeStringField(AwsModule.SESSION_TOKEN, sessionCredentials.sessionToken());
                } else {
                    jsonGenerator.writeStringField(AwsModule.ACCESS_KEY_ID, credentials.accessKeyId());
                    jsonGenerator.writeStringField(AwsModule.SECRET_ACCESS_KEY, credentials.secretAccessKey());
                }
            } else if (!SINGLETON_CREDENTIAL_PROVIDERS.contains(credentialsProvider.getClass())) {
                throw new IllegalArgumentException("Unsupported AWS credentials provider type " + credentialsProvider.getClass());
            }
            typeSerializer.writeTypeSuffixForObject((Object)credentialsProvider, jsonGenerator);
        }
    }

    private static class AwsCredentialsProviderDeserializer
    extends JsonDeserializer<AwsCredentialsProvider> {
        private AwsCredentialsProviderDeserializer() {
        }

        public AwsCredentialsProvider deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            return (AwsCredentialsProvider)context.readValue(jsonParser, AwsCredentialsProvider.class);
        }

        public AwsCredentialsProvider deserializeWithType(JsonParser jsonParser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
            String typeNameKey;
            Map asMap = (Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, String>>(){});
            String typeName = (String)asMap.get(typeNameKey = typeDeserializer.getPropertyName());
            if (typeName == null) {
                throw new IOException(String.format("AWS credentials provider type name key '%s' not found", typeNameKey));
            }
            if (typeName.equals(StaticCredentialsProvider.class.getSimpleName())) {
                boolean isSession = asMap.containsKey(AwsModule.SESSION_TOKEN);
                if (isSession) {
                    return StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)((String)asMap.get(AwsModule.ACCESS_KEY_ID)), (String)((String)asMap.get(AwsModule.SECRET_ACCESS_KEY)), (String)((String)asMap.get(AwsModule.SESSION_TOKEN))));
                }
                return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)((String)asMap.get(AwsModule.ACCESS_KEY_ID)), (String)((String)asMap.get(AwsModule.SECRET_ACCESS_KEY))));
            }
            if (typeName.equals(DefaultCredentialsProvider.class.getSimpleName())) {
                return DefaultCredentialsProvider.create();
            }
            if (typeName.equals(EnvironmentVariableCredentialsProvider.class.getSimpleName())) {
                return EnvironmentVariableCredentialsProvider.create();
            }
            if (typeName.equals(SystemPropertyCredentialsProvider.class.getSimpleName())) {
                return SystemPropertyCredentialsProvider.create();
            }
            if (typeName.equals(ProfileCredentialsProvider.class.getSimpleName())) {
                return ProfileCredentialsProvider.create();
            }
            if (typeName.equals(ContainerCredentialsProvider.class.getSimpleName())) {
                return ContainerCredentialsProvider.builder().build();
            }
            throw new IOException(String.format("AWS credential provider type '%s' is not supported", typeName));
        }
    }

    @JsonDeserialize(using=AwsCredentialsProviderDeserializer.class)
    @JsonSerialize(using=AWSCredentialsProviderSerializer.class)
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
    private static class AwsCredentialsProviderMixin {
        private AwsCredentialsProviderMixin() {
        }
    }
}

