/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.io.Serializable;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.aws2.kinesis.WatermarkParameters;
import org.apache.beam.sdk.io.aws2.kinesis.WatermarkPolicy;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Ordering;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public interface WatermarkPolicyFactory
extends Serializable {
    public WatermarkPolicy createWatermarkPolicy();

    public static WatermarkPolicyFactory withArrivalTimePolicy() {
        return ArrivalTimeWatermarkPolicy::new;
    }

    public static WatermarkPolicyFactory withArrivalTimePolicy(Duration watermarkIdleDurationThreshold) {
        return () -> new ArrivalTimeWatermarkPolicy(watermarkIdleDurationThreshold);
    }

    public static WatermarkPolicyFactory withProcessingTimePolicy() {
        return ProcessingTimeWatermarkPolicy::new;
    }

    public static WatermarkPolicyFactory withCustomWatermarkPolicy(WatermarkParameters watermarkParameters) {
        return () -> new CustomWatermarkPolicy(watermarkParameters);
    }

    public static class ProcessingTimeWatermarkPolicy
    implements WatermarkPolicy {
        @Override
        public Instant getWatermark() {
            return Instant.now();
        }

        @Override
        public void update(KinesisRecord record) {
        }
    }

    public static class CustomWatermarkPolicy
    implements WatermarkPolicy {
        private WatermarkParameters watermarkParameters;

        CustomWatermarkPolicy(WatermarkParameters watermarkParameters) {
            this.watermarkParameters = watermarkParameters;
        }

        @Override
        public Instant getWatermark() {
            Instant newWatermark;
            Instant now = Instant.now();
            Instant watermarkIdleThreshold = now.minus((ReadableDuration)this.watermarkParameters.getWatermarkIdleDurationThreshold());
            Instant instant = newWatermark = this.watermarkParameters.getLastUpdateTime().isBefore((ReadableInstant)watermarkIdleThreshold) ? watermarkIdleThreshold : this.watermarkParameters.getEventTime();
            if (newWatermark.isAfter((ReadableInstant)this.watermarkParameters.getCurrentWatermark())) {
                this.watermarkParameters = this.watermarkParameters.toBuilder().setCurrentWatermark(newWatermark).build();
            }
            return this.watermarkParameters.getCurrentWatermark();
        }

        @Override
        public void update(KinesisRecord record) {
            this.watermarkParameters = this.watermarkParameters.toBuilder().setEventTime((Instant)Ordering.natural().max((Object)this.watermarkParameters.getEventTime(), (Object)((Instant)this.watermarkParameters.getTimestampFn().apply((Object)record)))).setLastUpdateTime(Instant.now()).build();
        }
    }

    public static class ArrivalTimeWatermarkPolicy
    implements WatermarkPolicy {
        private final CustomWatermarkPolicy watermarkPolicy;

        ArrivalTimeWatermarkPolicy() {
            this.watermarkPolicy = new CustomWatermarkPolicy(WatermarkParameters.create().withTimestampFn((SerializableFunction<KinesisRecord, Instant>)((SerializableFunction & Serializable)KinesisRecord::getApproximateArrivalTimestamp)));
        }

        ArrivalTimeWatermarkPolicy(Duration idleDurationThreshold) {
            WatermarkParameters watermarkParameters = WatermarkParameters.create().withTimestampFn((SerializableFunction<KinesisRecord, Instant>)((SerializableFunction & Serializable)KinesisRecord::getApproximateArrivalTimestamp)).withWatermarkIdleDurationThreshold(idleDurationThreshold);
            this.watermarkPolicy = new CustomWatermarkPolicy(watermarkParameters);
        }

        @Override
        public Instant getWatermark() {
            return this.watermarkPolicy.getWatermark();
        }

        @Override
        public void update(KinesisRecord record) {
            this.watermarkPolicy.update(record);
        }
    }
}

