/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.beam.sdk.io.aws2.kinesis.AutoValue_WatermarkParameters;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecord;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.joda.time.Duration;
import org.joda.time.Instant;

@AutoValue
public abstract class WatermarkParameters
implements Serializable {
    private static final SerializableFunction<KinesisRecord, Instant> ARRIVAL_TIME_FN = KinesisRecord::getApproximateArrivalTimestamp;
    private static final Duration STANDARD_WATERMARK_IDLE_DURATION_THRESHOLD = Duration.standardMinutes((long)2L);

    abstract Instant getCurrentWatermark();

    abstract Instant getEventTime();

    abstract Instant getLastUpdateTime();

    abstract SerializableFunction<KinesisRecord, Instant> getTimestampFn();

    abstract Duration getWatermarkIdleDurationThreshold();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_WatermarkParameters.Builder().setCurrentWatermark(BoundedWindow.TIMESTAMP_MIN_VALUE).setEventTime(BoundedWindow.TIMESTAMP_MIN_VALUE).setTimestampFn(ARRIVAL_TIME_FN).setLastUpdateTime(Instant.now()).setWatermarkIdleDurationThreshold(STANDARD_WATERMARK_IDLE_DURATION_THRESHOLD);
    }

    public static WatermarkParameters create() {
        return WatermarkParameters.builder().build();
    }

    public WatermarkParameters withTimestampFn(SerializableFunction<KinesisRecord, Instant> timestampFn) {
        Preconditions.checkArgument((timestampFn != null ? 1 : 0) != 0, (Object)"timestampFn function is null");
        return WatermarkParameters.builder().setTimestampFn(timestampFn).build();
    }

    public WatermarkParameters withWatermarkIdleDurationThreshold(Duration idleDurationThreshold) {
        Preconditions.checkArgument((idleDurationThreshold != null ? 1 : 0) != 0, (Object)"watermark idle duration threshold is null");
        return WatermarkParameters.builder().setWatermarkIdleDurationThreshold(idleDurationThreshold).build();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setCurrentWatermark(Instant var1);

        abstract Builder setEventTime(Instant var1);

        abstract Builder setLastUpdateTime(Instant var1);

        abstract Builder setWatermarkIdleDurationThreshold(Duration var1);

        abstract Builder setTimestampFn(SerializableFunction<KinesisRecord, Instant> var1);

        abstract WatermarkParameters build();
    }
}

