/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;
import software.amazon.kinesis.common.InitialPositionInStream;

class StartingPoint
implements Serializable {
    private final InitialPositionInStream position;
    private final Instant timestamp;

    public StartingPoint(InitialPositionInStream position) {
        this.position = (InitialPositionInStream)Preconditions.checkNotNull((Object)position, (Object)"position");
        this.timestamp = null;
    }

    public StartingPoint(Instant timestamp) {
        this.timestamp = (Instant)Preconditions.checkNotNull((Object)timestamp, (Object)"timestamp");
        this.position = null;
    }

    public InitialPositionInStream getPosition() {
        return this.position;
    }

    public String getPositionName() {
        return this.position != null ? this.position.name() : ShardIteratorType.AT_TIMESTAMP.name();
    }

    public Instant getTimestamp() {
        return this.timestamp != null ? this.timestamp : null;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartingPoint that = (StartingPoint)o;
        return this.position == that.position && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.timestamp);
    }

    public String toString() {
        if (this.timestamp == null) {
            return this.position.toString();
        }
        return "Starting at timestamp " + this.timestamp;
    }
}

