/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.io.Serializable;
import java.util.List;
import java.util.function.Supplier;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.aws2.kinesis.RateLimitPolicy;
import org.joda.time.Duration;

public interface RateLimitPolicyFactory
extends Serializable {
    public RateLimitPolicy getRateLimitPolicy();

    public static RateLimitPolicyFactory withoutLimiter() {
        return () -> new RateLimitPolicy(){};
    }

    public static RateLimitPolicyFactory withFixedDelay() {
        return DelayIntervalRateLimiter::new;
    }

    public static RateLimitPolicyFactory withFixedDelay(Duration delay) {
        return () -> new DelayIntervalRateLimiter(() -> delay);
    }

    public static RateLimitPolicyFactory withDelay(Supplier<Duration> delay) {
        return () -> new DelayIntervalRateLimiter(delay);
    }

    public static class DelayIntervalRateLimiter
    implements RateLimitPolicy {
        private static final Supplier<Duration> DEFAULT_DELAY = () -> Duration.standardSeconds((long)1L);
        private final Supplier<Duration> delay;

        public DelayIntervalRateLimiter() {
            this(DEFAULT_DELAY);
        }

        public DelayIntervalRateLimiter(Supplier<Duration> delay) {
            this.delay = delay;
        }

        @Override
        public void onSuccess(List<KinesisRecord> records) throws InterruptedException {
            Thread.sleep(this.delay.get().getMillis());
        }
    }
}

