/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws2.kinesis.AWSClientsProvider;
import org.apache.beam.sdk.io.aws2.kinesis.CheckpointGenerator;
import org.apache.beam.sdk.io.aws2.kinesis.DynamicCheckpointGenerator;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisReader;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisReaderCheckpoint;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecordCoder;
import org.apache.beam.sdk.io.aws2.kinesis.RateLimitPolicyFactory;
import org.apache.beam.sdk.io.aws2.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.aws2.kinesis.StartingPoint;
import org.apache.beam.sdk.io.aws2.kinesis.StaticCheckpointGenerator;
import org.apache.beam.sdk.io.aws2.kinesis.WatermarkPolicyFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KinesisSource
extends UnboundedSource<KinesisRecord, KinesisReaderCheckpoint> {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisSource.class);
    private final AWSClientsProvider awsClientsProvider;
    private final String streamName;
    private final Duration upToDateThreshold;
    private final WatermarkPolicyFactory watermarkPolicyFactory;
    private final RateLimitPolicyFactory rateLimitPolicyFactory;
    private CheckpointGenerator initialCheckpointGenerator;
    private final Integer limit;
    private final Integer maxCapacityPerShard;

    KinesisSource(AWSClientsProvider awsClientsProvider, String streamName, StartingPoint startingPoint, Duration upToDateThreshold, WatermarkPolicyFactory watermarkPolicyFactory, RateLimitPolicyFactory rateLimitPolicyFactory, Integer limit, Integer maxCapacityPerShard) {
        this(awsClientsProvider, new DynamicCheckpointGenerator(streamName, startingPoint), streamName, upToDateThreshold, watermarkPolicyFactory, rateLimitPolicyFactory, limit, maxCapacityPerShard);
    }

    private KinesisSource(AWSClientsProvider awsClientsProvider, CheckpointGenerator initialCheckpoint, String streamName, Duration upToDateThreshold, WatermarkPolicyFactory watermarkPolicyFactory, RateLimitPolicyFactory rateLimitPolicyFactory, Integer limit, Integer maxCapacityPerShard) {
        this.awsClientsProvider = awsClientsProvider;
        this.initialCheckpointGenerator = initialCheckpoint;
        this.streamName = streamName;
        this.upToDateThreshold = upToDateThreshold;
        this.watermarkPolicyFactory = watermarkPolicyFactory;
        this.rateLimitPolicyFactory = rateLimitPolicyFactory;
        this.limit = limit;
        this.maxCapacityPerShard = maxCapacityPerShard;
        this.validate();
    }

    public List<KinesisSource> split(int desiredNumSplits, PipelineOptions options) throws Exception {
        KinesisReaderCheckpoint checkpoint = this.initialCheckpointGenerator.generate(SimplifiedKinesisClient.from(this.awsClientsProvider, this.limit));
        ArrayList sources = Lists.newArrayList();
        for (KinesisReaderCheckpoint partition : checkpoint.splitInto(desiredNumSplits)) {
            sources.add(new KinesisSource(this.awsClientsProvider, new StaticCheckpointGenerator(partition), this.streamName, this.upToDateThreshold, this.watermarkPolicyFactory, this.rateLimitPolicyFactory, this.limit, this.maxCapacityPerShard));
        }
        return sources;
    }

    public UnboundedSource.UnboundedReader<KinesisRecord> createReader(PipelineOptions options, KinesisReaderCheckpoint checkpointMark) {
        CheckpointGenerator checkpointGenerator = this.initialCheckpointGenerator;
        if (checkpointMark != null) {
            checkpointGenerator = new StaticCheckpointGenerator(checkpointMark);
        }
        LOG.info("Creating new reader using {}", (Object)checkpointGenerator);
        return new KinesisReader(SimplifiedKinesisClient.from(this.awsClientsProvider, this.limit), checkpointGenerator, this, this.watermarkPolicyFactory, this.rateLimitPolicyFactory, this.upToDateThreshold, this.maxCapacityPerShard);
    }

    public Coder<KinesisReaderCheckpoint> getCheckpointMarkCoder() {
        return SerializableCoder.of(KinesisReaderCheckpoint.class);
    }

    public void validate() {
        Preconditions.checkNotNull((Object)this.awsClientsProvider);
        Preconditions.checkNotNull((Object)this.initialCheckpointGenerator);
        Preconditions.checkNotNull((Object)this.watermarkPolicyFactory);
        Preconditions.checkNotNull((Object)this.rateLimitPolicyFactory);
    }

    public Coder<KinesisRecord> getOutputCoder() {
        return KinesisRecordCoder.of();
    }

    String getStreamName() {
        return this.streamName;
    }
}

