/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.io.aws2.kinesis.TimeUtil;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;
import software.amazon.kinesis.retrieval.KinesisClientRecord;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;

public class KinesisRecord {
    private Instant readTime;
    private String streamName;
    private String shardId;
    private long subSequenceNumber;
    private String sequenceNumber;
    private Instant approximateArrivalTimestamp;
    private ByteBuffer data;
    private String partitionKey;

    public KinesisRecord(KinesisClientRecord record, String streamName, String shardId) {
        this(record.data(), record.sequenceNumber(), record.subSequenceNumber(), record.partitionKey(), TimeUtil.toJoda(record.approximateArrivalTimestamp()), Instant.now(), streamName, shardId);
    }

    public KinesisRecord(ByteBuffer data, String sequenceNumber, long subSequenceNumber, String partitionKey, Instant approximateArrivalTimestamp, Instant readTime, String streamName, String shardId) {
        this.data = this.copyData(data);
        this.sequenceNumber = sequenceNumber;
        this.subSequenceNumber = subSequenceNumber;
        this.partitionKey = partitionKey;
        this.approximateArrivalTimestamp = approximateArrivalTimestamp;
        this.readTime = readTime;
        this.streamName = streamName;
        this.shardId = shardId;
    }

    private ByteBuffer copyData(ByteBuffer data) {
        data.rewind();
        byte[] bytes = new byte[data.remaining()];
        data.get(bytes);
        return ByteBuffer.wrap(bytes);
    }

    public ExtendedSequenceNumber getExtendedSequenceNumber() {
        return new ExtendedSequenceNumber(this.getSequenceNumber(), Long.valueOf(this.getSubSequenceNumber()));
    }

    public byte[] getUniqueId() {
        return this.getExtendedSequenceNumber().toString().getBytes(StandardCharsets.UTF_8);
    }

    public Instant getReadTime() {
        return this.readTime;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getShardId() {
        return this.shardId;
    }

    public byte[] getDataAsBytes() {
        return this.getData().array();
    }

    public boolean equals(@Nullable Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public long getSubSequenceNumber() {
        return this.subSequenceNumber;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Instant getApproximateArrivalTimestamp() {
        return this.approximateArrivalTimestamp;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }
}

