/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws2.kinesis.ShardCheckpoint;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;

class KinesisReaderCheckpoint
implements Iterable<ShardCheckpoint>,
UnboundedSource.CheckpointMark,
Serializable {
    private final List<ShardCheckpoint> shardCheckpoints;

    public KinesisReaderCheckpoint(Iterable<ShardCheckpoint> shardCheckpoints) {
        this.shardCheckpoints = ImmutableList.copyOf(shardCheckpoints);
    }

    public List<KinesisReaderCheckpoint> splitInto(int desiredNumSplits) {
        int partitionSize = this.divideAndRoundUp(this.shardCheckpoints.size(), desiredNumSplits);
        ArrayList checkpoints = Lists.newArrayList();
        for (List shardPartition : Lists.partition(this.shardCheckpoints, (int)partitionSize)) {
            checkpoints.add(new KinesisReaderCheckpoint(shardPartition));
        }
        return checkpoints;
    }

    private int divideAndRoundUp(int nominator, int denominator) {
        return (nominator + denominator - 1) / denominator;
    }

    public void finalizeCheckpoint() throws IOException {
    }

    public String toString() {
        return this.shardCheckpoints.toString();
    }

    @Override
    public Iterator<ShardCheckpoint> iterator() {
        return this.shardCheckpoints.iterator();
    }
}

