/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import com.google.auto.value.AutoValue;
import java.util.function.Supplier;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws2.kinesis.AWSClientsProvider;
import org.apache.beam.sdk.io.aws2.kinesis.AutoValue_KinesisIO_Read;
import org.apache.beam.sdk.io.aws2.kinesis.BasicKinesisProvider;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisSource;
import org.apache.beam.sdk.io.aws2.kinesis.RateLimitPolicyFactory;
import org.apache.beam.sdk.io.aws2.kinesis.StartingPoint;
import org.apache.beam.sdk.io.aws2.kinesis.WatermarkPolicyFactory;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;
import software.amazon.kinesis.common.InitialPositionInStream;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public final class KinesisIO {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisIO.class);
    private static final int DEFAULT_NUM_RETRIES = 6;

    public static Read read() {
        return new AutoValue_KinesisIO_Read.Builder().setMaxNumRecords(Long.MAX_VALUE).setUpToDateThreshold(Duration.ZERO).setWatermarkPolicyFactory(WatermarkPolicyFactory.withArrivalTimePolicy()).setRateLimitPolicyFactory(RateLimitPolicyFactory.withoutLimiter()).setMaxCapacityPerShard(10000).build();
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<KinesisRecord>> {
        abstract @Nullable String getStreamName();

        abstract @Nullable StartingPoint getInitialPosition();

        abstract @Nullable AWSClientsProvider getAWSClientsProvider();

        abstract long getMaxNumRecords();

        abstract @Nullable Duration getMaxReadTime();

        abstract Duration getUpToDateThreshold();

        abstract @Nullable Integer getRequestRecordsLimit();

        abstract WatermarkPolicyFactory getWatermarkPolicyFactory();

        abstract RateLimitPolicyFactory getRateLimitPolicyFactory();

        abstract Integer getMaxCapacityPerShard();

        abstract Builder toBuilder();

        public Read withStreamName(String streamName) {
            return this.toBuilder().setStreamName(streamName).build();
        }

        public Read withInitialPositionInStream(InitialPositionInStream initialPosition) {
            return this.toBuilder().setInitialPosition(new StartingPoint(initialPosition)).build();
        }

        public Read withInitialTimestampInStream(Instant initialTimestamp) {
            return this.toBuilder().setInitialPosition(new StartingPoint(initialTimestamp)).build();
        }

        public Read withAWSClientsProvider(AWSClientsProvider awsClientsProvider) {
            return this.toBuilder().setAWSClientsProvider(awsClientsProvider).build();
        }

        public Read withAWSClientsProvider(String awsAccessKey, String awsSecretKey, Region region) {
            return this.withAWSClientsProvider(awsAccessKey, awsSecretKey, region, null);
        }

        public Read withAWSClientsProvider(String awsAccessKey, String awsSecretKey, Region region, String serviceEndpoint) {
            return this.withAWSClientsProvider(new BasicKinesisProvider(awsAccessKey, awsSecretKey, region, serviceEndpoint));
        }

        public Read withMaxNumRecords(long maxNumRecords) {
            Preconditions.checkArgument((maxNumRecords > 0L ? 1 : 0) != 0, (String)"maxNumRecords must be positive, but was: %s", (long)maxNumRecords);
            return this.toBuilder().setMaxNumRecords(maxNumRecords).build();
        }

        public Read withMaxReadTime(Duration maxReadTime) {
            Preconditions.checkArgument((maxReadTime != null ? 1 : 0) != 0, (Object)"maxReadTime can not be null");
            return this.toBuilder().setMaxReadTime(maxReadTime).build();
        }

        public Read withUpToDateThreshold(Duration upToDateThreshold) {
            Preconditions.checkArgument((upToDateThreshold != null ? 1 : 0) != 0, (Object)"upToDateThreshold can not be null");
            return this.toBuilder().setUpToDateThreshold(upToDateThreshold).build();
        }

        public Read withRequestRecordsLimit(int limit) {
            Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (String)"limit must be positive, but was: %s", (int)limit);
            Preconditions.checkArgument((limit <= 10000 ? 1 : 0) != 0, (String)"limit must be up to 10,000, but was: %s", (int)limit);
            return this.toBuilder().setRequestRecordsLimit(limit).build();
        }

        public Read withArrivalTimeWatermarkPolicy() {
            return this.toBuilder().setWatermarkPolicyFactory(WatermarkPolicyFactory.withArrivalTimePolicy()).build();
        }

        public Read withArrivalTimeWatermarkPolicy(Duration watermarkIdleDurationThreshold) {
            return this.toBuilder().setWatermarkPolicyFactory(WatermarkPolicyFactory.withArrivalTimePolicy(watermarkIdleDurationThreshold)).build();
        }

        public Read withProcessingTimeWatermarkPolicy() {
            return this.toBuilder().setWatermarkPolicyFactory(WatermarkPolicyFactory.withProcessingTimePolicy()).build();
        }

        public Read withCustomWatermarkPolicy(WatermarkPolicyFactory watermarkPolicyFactory) {
            Preconditions.checkArgument((watermarkPolicyFactory != null ? 1 : 0) != 0, (Object)"watermarkPolicyFactory cannot be null");
            return this.toBuilder().setWatermarkPolicyFactory(watermarkPolicyFactory).build();
        }

        public Read withFixedDelayRateLimitPolicy() {
            return this.toBuilder().setRateLimitPolicyFactory(RateLimitPolicyFactory.withFixedDelay()).build();
        }

        public Read withFixedDelayRateLimitPolicy(Duration delay) {
            Preconditions.checkArgument((delay != null ? 1 : 0) != 0, (Object)"delay cannot be null");
            return this.toBuilder().setRateLimitPolicyFactory(RateLimitPolicyFactory.withFixedDelay(delay)).build();
        }

        public Read withDynamicDelayRateLimitPolicy(Supplier<Duration> delay) {
            Preconditions.checkArgument((delay != null ? 1 : 0) != 0, (Object)"delay cannot be null");
            return this.toBuilder().setRateLimitPolicyFactory(RateLimitPolicyFactory.withDelay(delay)).build();
        }

        public Read withCustomRateLimitPolicy(RateLimitPolicyFactory rateLimitPolicyFactory) {
            Preconditions.checkArgument((rateLimitPolicyFactory != null ? 1 : 0) != 0, (Object)"rateLimitPolicyFactory cannot be null");
            return this.toBuilder().setRateLimitPolicyFactory(rateLimitPolicyFactory).build();
        }

        public Read withMaxCapacityPerShard(Integer maxCapacity) {
            Preconditions.checkArgument((maxCapacity > 0 ? 1 : 0) != 0, (String)"maxCapacity must be positive, but was: %s", (Object)maxCapacity);
            return this.toBuilder().setMaxCapacityPerShard(maxCapacity).build();
        }

        public PCollection<KinesisRecord> expand(PBegin input) {
            Read.Unbounded unbounded;
            Read.Unbounded transform = unbounded = org.apache.beam.sdk.io.Read.from((UnboundedSource)new KinesisSource(this.getAWSClientsProvider(), this.getStreamName(), this.getInitialPosition(), this.getUpToDateThreshold(), this.getWatermarkPolicyFactory(), this.getRateLimitPolicyFactory(), this.getRequestRecordsLimit(), this.getMaxCapacityPerShard()));
            if (this.getMaxNumRecords() < Long.MAX_VALUE || this.getMaxReadTime() != null) {
                transform = unbounded.withMaxReadTime(this.getMaxReadTime()).withMaxNumRecords(this.getMaxNumRecords());
            }
            return (PCollection)input.apply((PTransform)transform);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setStreamName(String var1);

            abstract Builder setInitialPosition(StartingPoint var1);

            abstract Builder setAWSClientsProvider(AWSClientsProvider var1);

            abstract Builder setMaxNumRecords(long var1);

            abstract Builder setMaxReadTime(Duration var1);

            abstract Builder setUpToDateThreshold(Duration var1);

            abstract Builder setRequestRecordsLimit(Integer var1);

            abstract Builder setWatermarkPolicyFactory(WatermarkPolicyFactory var1);

            abstract Builder setRateLimitPolicyFactory(RateLimitPolicyFactory var1);

            abstract Builder setMaxCapacityPerShard(Integer var1);

            abstract Read build();
        }
    }
}

