/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import org.apache.beam.sdk.io.aws2.kinesis.AWSClientsProvider;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisIO;
import org.apache.beam.sdk.io.aws2.kinesis.RateLimitPolicyFactory;
import org.apache.beam.sdk.io.aws2.kinesis.StartingPoint;
import org.apache.beam.sdk.io.aws2.kinesis.WatermarkPolicyFactory;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

final class AutoValue_KinesisIO_Read
extends KinesisIO.Read {
    private final @Nullable String streamName;
    private final @Nullable StartingPoint initialPosition;
    private final @Nullable AWSClientsProvider AWSClientsProvider;
    private final long maxNumRecords;
    private final @Nullable Duration maxReadTime;
    private final Duration upToDateThreshold;
    private final @Nullable Integer requestRecordsLimit;
    private final WatermarkPolicyFactory watermarkPolicyFactory;
    private final RateLimitPolicyFactory rateLimitPolicyFactory;
    private final Integer maxCapacityPerShard;

    private AutoValue_KinesisIO_Read(@Nullable String streamName, @Nullable StartingPoint initialPosition, @Nullable AWSClientsProvider AWSClientsProvider2, long maxNumRecords, @Nullable Duration maxReadTime, Duration upToDateThreshold, @Nullable Integer requestRecordsLimit, WatermarkPolicyFactory watermarkPolicyFactory, RateLimitPolicyFactory rateLimitPolicyFactory, Integer maxCapacityPerShard) {
        this.streamName = streamName;
        this.initialPosition = initialPosition;
        this.AWSClientsProvider = AWSClientsProvider2;
        this.maxNumRecords = maxNumRecords;
        this.maxReadTime = maxReadTime;
        this.upToDateThreshold = upToDateThreshold;
        this.requestRecordsLimit = requestRecordsLimit;
        this.watermarkPolicyFactory = watermarkPolicyFactory;
        this.rateLimitPolicyFactory = rateLimitPolicyFactory;
        this.maxCapacityPerShard = maxCapacityPerShard;
    }

    @Override
    @Nullable String getStreamName() {
        return this.streamName;
    }

    @Override
    @Nullable StartingPoint getInitialPosition() {
        return this.initialPosition;
    }

    @Override
    @Nullable AWSClientsProvider getAWSClientsProvider() {
        return this.AWSClientsProvider;
    }

    @Override
    long getMaxNumRecords() {
        return this.maxNumRecords;
    }

    @Override
    @Nullable Duration getMaxReadTime() {
        return this.maxReadTime;
    }

    @Override
    Duration getUpToDateThreshold() {
        return this.upToDateThreshold;
    }

    @Override
    @Nullable Integer getRequestRecordsLimit() {
        return this.requestRecordsLimit;
    }

    @Override
    WatermarkPolicyFactory getWatermarkPolicyFactory() {
        return this.watermarkPolicyFactory;
    }

    @Override
    RateLimitPolicyFactory getRateLimitPolicyFactory() {
        return this.rateLimitPolicyFactory;
    }

    @Override
    Integer getMaxCapacityPerShard() {
        return this.maxCapacityPerShard;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KinesisIO.Read) {
            KinesisIO.Read that = (KinesisIO.Read)((Object)o);
            return (this.streamName == null ? that.getStreamName() == null : this.streamName.equals(that.getStreamName())) && (this.initialPosition == null ? that.getInitialPosition() == null : this.initialPosition.equals(that.getInitialPosition())) && (this.AWSClientsProvider == null ? that.getAWSClientsProvider() == null : this.AWSClientsProvider.equals(that.getAWSClientsProvider())) && this.maxNumRecords == that.getMaxNumRecords() && (this.maxReadTime == null ? that.getMaxReadTime() == null : this.maxReadTime.equals((Object)that.getMaxReadTime())) && this.upToDateThreshold.equals((Object)that.getUpToDateThreshold()) && (this.requestRecordsLimit == null ? that.getRequestRecordsLimit() == null : this.requestRecordsLimit.equals(that.getRequestRecordsLimit())) && this.watermarkPolicyFactory.equals(that.getWatermarkPolicyFactory()) && this.rateLimitPolicyFactory.equals(that.getRateLimitPolicyFactory()) && this.maxCapacityPerShard.equals(that.getMaxCapacityPerShard());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.streamName == null ? 0 : this.streamName.hashCode();
        h$ *= 1000003;
        h$ ^= this.initialPosition == null ? 0 : this.initialPosition.hashCode();
        h$ *= 1000003;
        h$ ^= this.AWSClientsProvider == null ? 0 : this.AWSClientsProvider.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.maxNumRecords >>> 32 ^ this.maxNumRecords);
        h$ *= 1000003;
        h$ ^= this.maxReadTime == null ? 0 : this.maxReadTime.hashCode();
        h$ *= 1000003;
        h$ ^= this.upToDateThreshold.hashCode();
        h$ *= 1000003;
        h$ ^= this.requestRecordsLimit == null ? 0 : this.requestRecordsLimit.hashCode();
        h$ *= 1000003;
        h$ ^= this.watermarkPolicyFactory.hashCode();
        h$ *= 1000003;
        h$ ^= this.rateLimitPolicyFactory.hashCode();
        h$ *= 1000003;
        return h$ ^= this.maxCapacityPerShard.hashCode();
    }

    @Override
    KinesisIO.Read.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends KinesisIO.Read.Builder {
        private @Nullable String streamName;
        private @Nullable StartingPoint initialPosition;
        private @Nullable AWSClientsProvider AWSClientsProvider;
        private Long maxNumRecords;
        private @Nullable Duration maxReadTime;
        private Duration upToDateThreshold;
        private @Nullable Integer requestRecordsLimit;
        private WatermarkPolicyFactory watermarkPolicyFactory;
        private RateLimitPolicyFactory rateLimitPolicyFactory;
        private Integer maxCapacityPerShard;

        Builder() {
        }

        private Builder(KinesisIO.Read source) {
            this.streamName = source.getStreamName();
            this.initialPosition = source.getInitialPosition();
            this.AWSClientsProvider = source.getAWSClientsProvider();
            this.maxNumRecords = source.getMaxNumRecords();
            this.maxReadTime = source.getMaxReadTime();
            this.upToDateThreshold = source.getUpToDateThreshold();
            this.requestRecordsLimit = source.getRequestRecordsLimit();
            this.watermarkPolicyFactory = source.getWatermarkPolicyFactory();
            this.rateLimitPolicyFactory = source.getRateLimitPolicyFactory();
            this.maxCapacityPerShard = source.getMaxCapacityPerShard();
        }

        @Override
        KinesisIO.Read.Builder setStreamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setInitialPosition(StartingPoint initialPosition) {
            this.initialPosition = initialPosition;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setAWSClientsProvider(AWSClientsProvider AWSClientsProvider2) {
            this.AWSClientsProvider = AWSClientsProvider2;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setMaxNumRecords(long maxNumRecords) {
            this.maxNumRecords = maxNumRecords;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setMaxReadTime(Duration maxReadTime) {
            this.maxReadTime = maxReadTime;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setUpToDateThreshold(Duration upToDateThreshold) {
            if (upToDateThreshold == null) {
                throw new NullPointerException("Null upToDateThreshold");
            }
            this.upToDateThreshold = upToDateThreshold;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setRequestRecordsLimit(Integer requestRecordsLimit) {
            this.requestRecordsLimit = requestRecordsLimit;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setWatermarkPolicyFactory(WatermarkPolicyFactory watermarkPolicyFactory) {
            if (watermarkPolicyFactory == null) {
                throw new NullPointerException("Null watermarkPolicyFactory");
            }
            this.watermarkPolicyFactory = watermarkPolicyFactory;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setRateLimitPolicyFactory(RateLimitPolicyFactory rateLimitPolicyFactory) {
            if (rateLimitPolicyFactory == null) {
                throw new NullPointerException("Null rateLimitPolicyFactory");
            }
            this.rateLimitPolicyFactory = rateLimitPolicyFactory;
            return this;
        }

        @Override
        KinesisIO.Read.Builder setMaxCapacityPerShard(Integer maxCapacityPerShard) {
            if (maxCapacityPerShard == null) {
                throw new NullPointerException("Null maxCapacityPerShard");
            }
            this.maxCapacityPerShard = maxCapacityPerShard;
            return this;
        }

        @Override
        KinesisIO.Read build() {
            String missing = "";
            if (this.maxNumRecords == null) {
                missing = missing + " maxNumRecords";
            }
            if (this.upToDateThreshold == null) {
                missing = missing + " upToDateThreshold";
            }
            if (this.watermarkPolicyFactory == null) {
                missing = missing + " watermarkPolicyFactory";
            }
            if (this.rateLimitPolicyFactory == null) {
                missing = missing + " rateLimitPolicyFactory";
            }
            if (this.maxCapacityPerShard == null) {
                missing = missing + " maxCapacityPerShard";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_KinesisIO_Read(this.streamName, this.initialPosition, this.AWSClientsProvider, this.maxNumRecords, this.maxReadTime, this.upToDateThreshold, this.requestRecordsLimit, this.watermarkPolicyFactory, this.rateLimitPolicyFactory, this.maxCapacityPerShard);
        }
    }
}

