/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.aws2.sqs.EmbeddedSqsServer;
import org.apache.beam.sdk.io.aws2.sqs.SqsClientProvider;
import org.apache.beam.sdk.io.aws2.sqs.SqsClientProviderMock;
import org.apache.beam.sdk.io.aws2.sqs.SqsIO;
import org.apache.beam.sdk.io.aws2.sqs.SqsUnboundedSource;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.testing.TestPipeline;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;

@RunWith(value=JUnit4.class)
public class SqsUnboundedSourceTest {
    private static final String DATA = "testData";
    @Rule
    public TestPipeline pipeline = TestPipeline.create();
    @Rule
    public EmbeddedSqsServer embeddedSqsRestServer = new EmbeddedSqsServer();

    @Test
    public void testCheckpointCoderIsSane() {
        SqsClient client = this.embeddedSqsRestServer.getClient();
        String queueUrl = this.embeddedSqsRestServer.getQueueUrl();
        client.sendMessage((SendMessageRequest)SendMessageRequest.builder().queueUrl(queueUrl).messageBody(DATA).build());
        SqsUnboundedSource source = new SqsUnboundedSource(SqsIO.read().withQueueUrl(queueUrl).withSqsClientProvider((SqsClientProvider)SqsClientProviderMock.of(client)).withMaxNumRecords(1L));
        CoderProperties.coderSerializable((Coder)source.getCheckpointMarkCoder());
    }
}

