/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import java.util.ArrayList;
import org.apache.beam.sdk.io.aws2.sqs.EmbeddedSqsServer;
import org.apache.beam.sdk.io.aws2.sqs.SqsClientProvider;
import org.apache.beam.sdk.io.aws2.sqs.SqsClientProviderMock;
import org.apache.beam.sdk.io.aws2.sqs.SqsIO;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;

@RunWith(value=JUnit4.class)
public class SqsIOTest {
    @Rule
    public TestPipeline pipeline = TestPipeline.create();
    @Rule
    public EmbeddedSqsServer embeddedSqsRestServer = new EmbeddedSqsServer();

    @Test
    public void testWrite() {
        SqsClient client = this.embeddedSqsRestServer.getClient();
        String queueUrl = this.embeddedSqsRestServer.getQueueUrl();
        ArrayList<SendMessageRequest> messages = new ArrayList<SendMessageRequest>();
        for (int i = 0; i < 100; ++i) {
            SendMessageRequest request = (SendMessageRequest)SendMessageRequest.builder().queueUrl(queueUrl).messageBody("This is a test " + i).build();
            messages.add(request);
        }
        ((PCollection)this.pipeline.apply((PTransform)Create.of(messages))).apply((PTransform)SqsIO.write().withSqsClientProvider((SqsClientProvider)SqsClientProviderMock.of(client)));
        this.pipeline.run().waitUntilFinish();
        ArrayList<String> received = new ArrayList<String>();
        while (received.size() < 100) {
            ReceiveMessageRequest receiveMessageRequest = (ReceiveMessageRequest)ReceiveMessageRequest.builder().queueUrl(queueUrl).build();
            ReceiveMessageResponse receiveMessageResponse = client.receiveMessage(receiveMessageRequest);
            if (receiveMessageResponse == null) continue;
            for (Message message : receiveMessageResponse.messages()) {
                received.add(message.body());
            }
        }
        Assert.assertEquals((long)100L, (long)received.size());
        for (int i = 0; i < 100; ++i) {
            received.contains("This is a test " + i);
        }
    }
}

