/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import java.net.URI;
import org.elasticmq.rest.sqs.SQSRestServer;
import org.elasticmq.rest.sqs.SQSRestServerBuilder;
import org.junit.rules.ExternalResource;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.CreateQueueResponse;

class EmbeddedSqsServer
extends ExternalResource {
    private static SQSRestServer sqsRestServer;
    private static SqsClient client;
    private static String queueUrl;
    private static int port;
    private static String endPoint;
    private static String queueName;

    EmbeddedSqsServer() {
    }

    protected void before() {
        sqsRestServer = SQSRestServerBuilder.withPort((int)port).start();
        client = (SqsClient)((SqsClientBuilder)((SqsClientBuilder)((SqsClientBuilder)SqsClient.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)"x", (String)"x")))).endpointOverride(URI.create(endPoint))).region(Region.US_WEST_2)).build();
        CreateQueueRequest createQueueRequest = (CreateQueueRequest)CreateQueueRequest.builder().queueName(queueName).build();
        CreateQueueResponse queue = client.createQueue(createQueueRequest);
        queueUrl = queue.queueUrl();
    }

    public SqsClient getClient() {
        return client;
    }

    public String getQueueUrl() {
        return queueUrl;
    }

    protected void after() {
        sqsRestServer.stopAndWait();
    }

    static {
        port = 9234;
        endPoint = String.format("http://localhost:%d", port);
        queueName = "test";
    }
}

